/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.google.Sets;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ReadDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionType;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;

abstract class PaginatingFunction<I, O>
extends ReadDataPlaneFunction<I, O> {
    protected static final boolean SEQUENTIAL_READS = false;
    protected static final Set<Select> LSI_SELECTS_TO_READ_FROM_BASE_TABLE = Sets.newHashSet(Select.ALL_ATTRIBUTES, Select.SPECIFIC_ATTRIBUTES);
    private final DocumentFactory documentFactory;

    PaginatingFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED);
        this.documentFactory = documentFactory;
    }

    protected List<String> determineAttributesToGetWhenSelectingAllProjectedAttributes(TableInfo tableInfo, String indexName, String projectionType, List<String> nonKeyAttributes) {
        switch (ProjectionType.fromValue((String)projectionType)) {
            case INCLUDE: {
                List attributesToGet = this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
                attributesToGet.addAll(nonKeyAttributes);
                return attributesToGet;
            }
            case KEYS_ONLY: {
                return this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
            }
            case ALL: {
                return null;
            }
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return null;
    }

    Select validateSelect(String selectStr, List<String> attrsToGet, ProjectionExpression projectionExpression, String indexName, TableInfo tableInfo) {
        Select newSelect = null;
        if (StringUtils.isEmpty((CharSequence)selectStr)) {
            newSelect = attrsToGet != null && !attrsToGet.isEmpty() || projectionExpression != null ? Select.SPECIFIC_ATTRIBUTES : (indexName != null ? Select.ALL_PROJECTED_ATTRIBUTES : Select.ALL_ATTRIBUTES);
        } else {
            newSelect = Select.fromValue((String)selectStr);
            if (newSelect.equals((Object)Select.UNKNOWN_TO_SDK_VERSION)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT.getMessage());
            }
            String addErrorInfo = null;
            if (attrsToGet != null && !attrsToGet.isEmpty() || projectionExpression != null) {
                addErrorInfo = attrsToGet != null && !attrsToGet.isEmpty() ? "AttributesToGet" : "ProjectionExpression";
            }
            switch (newSelect) {
                case ALL_ATTRIBUTES: {
                    Projection projection;
                    if (attrsToGet != null && !attrsToGet.isEmpty() || projectionExpression != null) {
                        String errorMessage = "Cannot specify the " + addErrorInfo + " when choosing to get " + String.valueOf(Select.ALL_ATTRIBUTES);
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, errorMessage);
                    }
                    if (indexName == null || indexName.isEmpty() || !tableInfo.isGSIIndex(indexName) || (projection = tableInfo.getProjection(indexName)) != null && ProjectionType.ALL.name().equals(projection.projectionTypeAsString())) break;
                    String errorMessage = "Select type " + String.valueOf(Select.ALL_ATTRIBUTES) + " is not supported for global secondary index " + indexName + " because its projection type is not " + String.valueOf(ProjectionType.ALL);
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), errorMessage));
                }
                case ALL_PROJECTED_ATTRIBUTES: {
                    if (attrsToGet != null && !attrsToGet.isEmpty() || projectionExpression != null) {
                        String errorMessage = "Cannot specify the " + addErrorInfo + " when choosing to get " + String.valueOf(Select.ALL_PROJECTED_ATTRIBUTES);
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, errorMessage);
                    }
                    if (!StringUtils.isEmpty((CharSequence)indexName)) break;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.valueOf(Select.ALL_PROJECTED_ATTRIBUTES) + " can be used only when Querying using an IndexName");
                }
                case COUNT: {
                    if (attrsToGet != null && !attrsToGet.isEmpty()) {
                        this.awsExceptionFactory.OBTAINING_COUNT_AND_ATTRIBUTES.throwAsException();
                        break;
                    }
                    if (projectionExpression == null) break;
                    this.awsExceptionFactory.OBTAINING_COUNT_AND_PROJECTIONEXPRESSION.throwAsException();
                    break;
                }
                case SPECIFIC_ATTRIBUTES: {
                    if ((attrsToGet == null || attrsToGet.isEmpty()) && projectionExpression == null) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Must specify the AttributesToGet or ProjectionExpression when choosing to get " + String.valueOf(Select.SPECIFIC_ATTRIBUTES));
                    }
                    this.validateAttributesToGetAndProjExpr((List)attrsToGet, projectionExpression, indexName, tableInfo);
                    break;
                }
                default: {
                    this.awsExceptionFactory.INTERNAL_FAILURE.throwAsException();
                }
            }
        }
        return newSelect;
    }
}

