/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.cp;

import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.api.cp.ControlPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public class DeleteTableFunction
extends ControlPlaneFunction<DeleteTableRequest, DeleteTableResponse> {
    public DeleteTableFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public DeleteTableResponse apply(DeleteTableRequest deleteTableRequest) {
        String unparsedTableName = deleteTableRequest.tableName();
        final String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        if (!tableName.equals(unparsedTableName)) {
            deleteTableRequest = (DeleteTableRequest)deleteTableRequest.toBuilder().tableName(tableName).build();
        }
        this.validateTableName(tableName);
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        if (description.deletionProtectionEnabled().booleanValue()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DELETE_PROTECTION_ENABLED.getMessage());
        }
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                DeleteTableFunction.this.dbAccess.deleteTable(tableName);
            }
        }.execute();
        return (DeleteTableResponse)DeleteTableResponse.builder().tableDescription(description).build();
    }
}

