/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.UnsignedByteArrayComparator;

public class EncoderDecoderUtils {
    private static final Charset m_utf8_charset = StandardCharsets.UTF_8;

    public static byte[] encodeString(String str) {
        return str.getBytes(m_utf8_charset);
    }

    public static String decodeString(byte[] ba) {
        return new String(ba, m_utf8_charset);
    }

    public static ArrayList<byte[]> getRawBytesForStringSet(List<String> stringSet) {
        ArrayList<byte[]> rawSetValue = new ArrayList<byte[]>(stringSet.size());
        for (String str : stringSet) {
            byte[] byteArrayEncodedString = EncoderDecoderUtils.encodeString(str);
            rawSetValue.add(byteArrayEncodedString);
        }
        Collections.sort(rawSetValue, UnsignedByteArrayComparator.SINGLETON);
        return rawSetValue;
    }

    public static ArrayList<byte[]> getRawBytesForNumberSet(List<String> numberSet) {
        ArrayList<byte[]> rawSetValue = new ArrayList<byte[]>(numberSet.size());
        for (String number : numberSet) {
            byte[] byteArrayEncodedBigDecimal = LocalDBUtils.encodeBigDecimal(new BigDecimal(number));
            rawSetValue.add(byteArrayEncodedBigDecimal);
        }
        Collections.sort(rawSetValue, UnsignedByteArrayComparator.SINGLETON);
        return rawSetValue;
    }

    public static List<byte[]> getRawBytesForBinarySet(List<ByteBuffer> byteBufferList) {
        ArrayList<byte[]> rawSetValue = new ArrayList<byte[]>(byteBufferList.size());
        for (ByteBuffer byteBuffer : byteBufferList) {
            byte[] localByteArray = new byte[byteBuffer.capacity()];
            byteBuffer.duplicate().get(localByteArray, 0, byteBuffer.limit());
            rawSetValue.add(localByteArray);
        }
        Collections.sort(rawSetValue, UnsignedByteArrayComparator.SINGLETON);
        return rawSetValue;
    }

    public static List<byte[]> getRawBytesForSdkBinarySet(List<SdkBytes> sdkBytesList) {
        ArrayList<byte[]> rawSetValue = new ArrayList<byte[]>(sdkBytesList.size());
        for (SdkBytes sdkBytes : sdkBytesList) {
            rawSetValue.add(sdkBytes.asByteArray());
        }
        Collections.sort(rawSetValue, UnsignedByteArrayComparator.SINGLETON);
        return rawSetValue;
    }
}

