/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbEnumerable;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbEnumerator;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbSchema;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTableScan;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbTable.class);
    private static volatile Map<JdbcType, RelDataType> jdbcTypeToRelDataType = null;
    private final String collectionName;
    private final DocumentDbSchemaTable tableMetadata;
    private final Statistic statistic;

    protected DocumentDbTable(String collectionName, DocumentDbSchemaTable tableMetadata) {
        super(Object[].class);
        this.collectionName = collectionName;
        this.tableMetadata = tableMetadata;
        this.statistic = tableMetadata.getEstimatedRecordCount() == -1L ? Statistics.UNKNOWN : Statistics.of((double)tableMetadata.getEstimatedRecordCount(), null);
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public String toString() {
        return "DocumentDbTable {" + this.tableMetadata.getSqlName() + "}";
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList fieldList = new ArrayList();
        if (jdbcTypeToRelDataType == null) {
            DocumentDbTable.initializeRelDataTypeMap(typeFactory);
        }
        for (Map.Entry entry : this.tableMetadata.getColumnMap().entrySet()) {
            JdbcType sqlType = ((DocumentDbSchemaColumn)entry.getValue()).getSqlType();
            if (sqlType == JdbcType.ARRAY || sqlType == JdbcType.JAVA_OBJECT) continue;
            RelDataType relDataType = jdbcTypeToRelDataType.get((Object)sqlType);
            if (relDataType == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.DATA_TYPE_TRANSFORM_VIOLATION, SqlError.UNSUPPORTED_TYPE, new Object[]{sqlType});
            }
            boolean nullable = !((DocumentDbSchemaColumn)entry.getValue()).isPrimaryKey();
            AbstractMap.SimpleEntry field = new AbstractMap.SimpleEntry(entry.getKey(), typeFactory.createTypeWithNullability(relDataType, nullable));
            fieldList.add(field);
        }
        return typeFactory.createStructType(fieldList);
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new DocumentDbQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new DocumentDbTableScan(cluster, cluster.traitSetOf((RelTrait)DocumentDbRel.CONVENTION), relOptTable, this, null, this.tableMetadata);
    }

    Enumerable<Object> aggregate(String databaseName, List<Map.Entry<String, Class<?>>> fields, List<String> paths, List<String> operations) {
        ArrayList<Bson> list = new ArrayList<Bson>();
        for (String operation : operations) {
            list.add((Bson)BsonDocument.parse((String)operation));
        }
        return new DocumentDbEnumerable(databaseName, this.collectionName, list, paths);
    }

    private static synchronized void initializeRelDataTypeMap(RelDataTypeFactory typeFactory) {
        if (jdbcTypeToRelDataType == null) {
            jdbcTypeToRelDataType = ImmutableMap.builder().put((Object)JdbcType.BIGINT, (Object)typeFactory.createSqlType(SqlTypeName.BIGINT)).put((Object)JdbcType.BOOLEAN, (Object)typeFactory.createSqlType(SqlTypeName.BOOLEAN)).put((Object)JdbcType.DECIMAL, (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL), typeFactory.getTypeSystem().getMaxScale(SqlTypeName.DECIMAL))).put((Object)JdbcType.DOUBLE, (Object)typeFactory.createSqlType(SqlTypeName.DOUBLE)).put((Object)JdbcType.INTEGER, (Object)typeFactory.createSqlType(SqlTypeName.INTEGER)).put((Object)JdbcType.NULL, (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR)).put((Object)JdbcType.TIMESTAMP, (Object)typeFactory.createSqlType(SqlTypeName.TIMESTAMP)).put((Object)JdbcType.VARCHAR, (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.VARCHAR))).put((Object)JdbcType.VARBINARY, (Object)typeFactory.createSqlType(SqlTypeName.VARBINARY, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.VARBINARY))).build();
        }
    }

    public static class DocumentDbQueryable<T>
    extends AbstractTableQueryable<T> {
        DocumentDbQueryable(QueryProvider queryProvider, SchemaPlus schema, DocumentDbTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            return new DocumentDbEnumerator();
        }

        private String getDatabaseName() {
            return this.getUnwrappedDocumentDbSchema().getDatabaseName();
        }

        private @NonNull DocumentDbSchema getUnwrappedDocumentDbSchema() {
            DocumentDbSchema result = (DocumentDbSchema)((Object)this.schema.unwrap(DocumentDbSchema.class));
            if (result != null) {
                return result;
            }
            throw new NullPointerException();
        }

        private DocumentDbTable getTable() {
            return (DocumentDbTable)this.table;
        }

        public Enumerable<Object> aggregate(List<Map.Entry<String, Class<?>>> fields, List<String> paths, List<String> operations) {
            return this.getTable().aggregate(this.getDatabaseName(), fields, paths, operations);
        }
    }
}

