/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.UnwindOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbToEnumerableConverter;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbTableSchemaGeneratorHelper;

public class DocumentDbJoin
extends Join
implements DocumentDbRel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbJoin.class.getName());

    public DocumentDbJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, (List)ImmutableList.of(), left, right, condition, (Set)ImmutableSet.of(), joinType);
        assert (this.getConvention() == DocumentDbRel.CONVENTION);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.1) : null;
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new DocumentDbJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        implementor.setJoin(true);
        implementor.visitChild(0, this.getLeft());
        DocumentDbTable leftTable = implementor.getDocumentDbTable();
        DocumentDbSchemaTable leftMetadata = implementor.getMetadataTable();
        DocumentDbRel.Implementor rightImplementor = new DocumentDbRel.Implementor(implementor.getRexBuilder());
        rightImplementor.setJoin(true);
        rightImplementor.visitChild(0, this.getRight());
        DocumentDbTable rightTable = rightImplementor.getDocumentDbTable();
        DocumentDbSchemaTable rightMetadata = rightImplementor.getMetadataTable();
        if (leftTable.getCollectionName().equals(rightTable.getCollectionName())) {
            this.joinSameCollection(implementor, rightImplementor, leftTable.getCollectionName(), leftMetadata, rightMetadata);
        } else {
            this.joinDifferentCollections(implementor, rightImplementor, leftTable.getCollectionName(), rightTable.getCollectionName(), leftMetadata, rightMetadata);
        }
        implementor.setJoin(false);
    }

    private void joinSameCollection(DocumentDbRel.Implementor implementor, DocumentDbRel.Implementor rightImplementor, String collectionName, DocumentDbSchemaTable leftTable, DocumentDbSchemaTable rightTable) {
        this.validateSameCollectionJoin(leftTable, rightTable);
        List<Pair<String, String>> leftList = implementor.getList();
        implementor.setList(new ArrayList<Pair<String, String>>());
        ImmutableList<DocumentDbSchemaColumn> leftFilterColumns = DocumentDbJoin.getFilterColumns(leftTable);
        ImmutableList<DocumentDbSchemaColumn> rightFilterColumns = DocumentDbJoin.getFilterColumns(rightTable);
        Supplier<String> leftFilter = () -> DocumentDbJoin.buildFieldsExistMatchFilter((ImmutableCollection<DocumentDbSchemaColumn>)leftFilterColumns);
        Supplier<String> rightFilter = () -> DocumentDbJoin.buildFieldsExistMatchFilter((ImmutableCollection<DocumentDbSchemaColumn>)rightFilterColumns);
        boolean rightIsVirtual = DocumentDbJoin.isTableVirtual(rightTable);
        boolean leftIsVirtual = DocumentDbJoin.isTableVirtual(leftTable);
        LinkedHashMap<String, DocumentDbSchemaColumn> leftColumns = this.getRequiredColumns(leftTable, () -> ((DocumentDbJoin)this).getLeft());
        LinkedHashMap<String, DocumentDbSchemaColumn> rightColumns = this.getRequiredColumns(rightTable, () -> ((DocumentDbJoin)this).getRight());
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>(leftColumns);
        ArrayList<String> resolutions = new ArrayList<String>();
        boolean resolutionNeedsUnwind = implementor.isResolutionNeedsUnwind() || rightImplementor.isResolutionNeedsUnwind();
        LinkedHashSet<String> usedKeys = new LinkedHashSet<String>(columnMap.keySet());
        for (Map.Entry entry : rightColumns.entrySet()) {
            String key = (String)entry.getKey();
            if (columnMap.containsKey(key)) {
                String newKey = SqlValidatorUtil.uniquify((String)key, usedKeys, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                DocumentDbSchemaColumn leftColumn = columnMap.get(key);
                if (((DocumentDbSchemaColumn)entry.getValue()).getFieldPath().equals(leftColumn.getFieldPath())) {
                    columnMap.put(newKey, (DocumentDbSchemaColumn)entry.getValue());
                    DocumentDbSchemaColumn column = (DocumentDbSchemaColumn)entry.getValue();
                    DocumentDbMetadataColumn newRightColumn = DocumentDbMetadataColumn.builder().fieldPath(column.getFieldPath()).sqlName(newKey).sqlType(column.getSqlType()).dbType(column.getDbType()).isIndex(column.isIndex()).isPrimaryKey(column.isPrimaryKey()).foreignKeyTableName(column.getForeignKeyTableName()).foreignKeyColumnName(column.getForeignKeyColumnName()).resolvedPath(newKey).build();
                    columnMap.put(newKey, newRightColumn);
                    resolutionNeedsUnwind = column.isIndex() || resolutionNeedsUnwind;
                    String leftPath = DocumentDbRules.getPath(leftColumn, true);
                    String rightPath = DocumentDbRules.getPath((DocumentDbSchemaColumn)entry.getValue(), true);
                    this.handleColumnRename((List<String>)resolutions, newKey, rightPath, rightIsVirtual, (ImmutableCollection<DocumentDbSchemaColumn>)rightFilterColumns);
                    this.handleColumnRename((List<String>)resolutions, leftPath, leftPath, leftIsVirtual, (ImmutableCollection<DocumentDbSchemaColumn>)leftFilterColumns);
                    continue;
                }
                columnMap.put(newKey, (DocumentDbSchemaColumn)entry.getValue());
                continue;
            }
            columnMap.put(key, (DocumentDbSchemaColumn)entry.getValue());
        }
        implementor.setResolutionNeedsUnwind(resolutionNeedsUnwind);
        rightImplementor.getUnwinds().forEach(op -> {
            if (!implementor.getUnwinds().contains(op)) {
                implementor.addUnwind((String)op);
            }
        });
        if (!resolutions.isEmpty()) {
            String newFields = Util.toString(resolutions, (String)"{", (String)", ", (String)"}");
            String aggregateString = "{ $addFields : " + newFields + "}";
            implementor.addCollisionResolution(aggregateString);
        }
        switch (this.getJoinType()) {
            case INNER: {
                String filterLeft = leftFilter.get();
                String filterRight = rightFilter.get();
                if (filterLeft != null) {
                    implementor.add(null, filterLeft);
                }
                if (filterRight != null) {
                    implementor.add(null, filterRight);
                }
                implementor.setNullFiltered(true);
                break;
            }
            case LEFT: {
                String filterLeft = leftFilter.get();
                if (filterLeft != null) {
                    implementor.add(null, filterLeft);
                }
                implementor.setNullFiltered(true);
                break;
            }
            default: {
                throw new IllegalArgumentException(SqlError.lookup(SqlError.UNSUPPORTED_JOIN_TYPE, this.getJoinType().name()));
            }
        }
        leftList.forEach(pair -> implementor.add((String)pair.left, (String)pair.right));
        rightImplementor.getList().forEach(pair -> implementor.add((String)pair.left, (String)pair.right));
        DocumentDbMetadataTable metadata = DocumentDbMetadataTable.builder().sqlName(leftTable.getSqlName()).collectionName(collectionName).columns(columnMap).build();
        DocumentDbTable joinedTable = new DocumentDbTable(collectionName, metadata);
        implementor.setDocumentDbTable(joinedTable);
        implementor.setMetadataTable(metadata);
    }

    static boolean isTableVirtual(DocumentDbSchemaTable table) {
        return table.getColumnMap().values().stream().anyMatch(c -> c.getForeignKeyTableName() != null && c.getForeignKeyColumnName() != null);
    }

    private void handleColumnRename(List<String> renames, String newKey, String originalPath, boolean tableIsVirtual, ImmutableCollection<DocumentDbSchemaColumn> filterColumns) {
        StringBuilder ifNullBuilder = new StringBuilder();
        String newPath = tableIsVirtual && DocumentDbJoin.tryBuildIfNullFieldsCondition(filterColumns, ifNullBuilder) ? "{ $cond : [ " + ifNullBuilder + ", " + DocumentDbRules.maybeQuote("$" + originalPath) + ", null ] }" : DocumentDbRules.maybeQuote("$" + originalPath);
        renames.add(DocumentDbRules.maybeQuote(newKey) + ": " + newPath);
    }

    static ImmutableList<DocumentDbSchemaColumn> getFilterColumns(DocumentDbSchemaTable table) {
        List columns = table.getColumnMap().values().stream().filter(c -> !c.isPrimaryKey() && c.getForeignKeyTableName() == null && (!(c instanceof DocumentDbMetadataColumn) || !((DocumentDbMetadataColumn)c).isGenerated()) && c.getSqlType() != null && c.getSqlType() != JdbcType.ARRAY && c.getSqlType() != JdbcType.JAVA_OBJECT && c.getSqlType() != JdbcType.NULL).collect(Collectors.toList());
        return ImmutableList.copyOf(columns);
    }

    static String buildFieldsExistMatchFilter(ImmutableCollection<DocumentDbSchemaColumn> columns) {
        StringBuilder builder = new StringBuilder();
        if (!DocumentDbJoin.tryBuildFieldsExists(columns, builder)) {
            return null;
        }
        builder.insert(0, "{ \"$match\": ");
        builder.append(" }");
        return builder.toString();
    }

    private static boolean tryBuildFieldsExists(ImmutableCollection<DocumentDbSchemaColumn> columns, StringBuilder builder) {
        int columnCount = 0;
        for (DocumentDbSchemaColumn column : columns) {
            if (columnCount != 0) {
                builder.append(", ");
            }
            builder.append("{ ");
            builder.append(DocumentDbRules.maybeQuote(column.getFieldPath()));
            builder.append(": { \"$exists\": true } }");
            ++columnCount;
        }
        if (columnCount == 0) {
            return false;
        }
        if (columnCount > 1) {
            builder.insert(0, "{ \"$or\": [ ");
            builder.append(" ] }");
        }
        return true;
    }

    private static boolean tryBuildIfNullFieldsCondition(ImmutableCollection<DocumentDbSchemaColumn> columns, StringBuilder builder) {
        int columnCount = 0;
        for (DocumentDbSchemaColumn column : columns) {
            if (columnCount != 0) {
                builder.append(", ");
            }
            builder.append("{ $ifNull: [ ");
            builder.append(DocumentDbRules.maybeQuote("$" + column.getFieldPath()));
            builder.append(", false ] }");
            ++columnCount;
        }
        if (columnCount == 0) {
            return false;
        }
        if (columnCount > 1) {
            builder.insert(0, "{ \"$or\": [ ");
            builder.append(" ] }");
        }
        return true;
    }

    private void validateSameCollectionJoin(DocumentDbSchemaTable left, DocumentDbSchemaTable right) {
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        ArrayList nonEquiList = new ArrayList();
        ArrayList filterNulls = new ArrayList();
        RelOptUtil.splitJoinCondition((RelNode)this.getLeft(), (RelNode)this.getRight(), (RexNode)this.getCondition(), leftKeys, rightKeys, filterNulls, nonEquiList);
        if (!nonEquiList.isEmpty()) {
            throw new IllegalArgumentException(SqlError.lookup(SqlError.EQUIJOINS_ON_FK_ONLY, new Object[0]));
        }
        List<String> leftNames = DocumentDbRules.mongoFieldNames(this.getLeft().getRowType(), left, true);
        List<String> rightNames = DocumentDbRules.mongoFieldNames(this.getRight().getRowType(), right, true);
        List<String> leftKeyNames = leftKeys.stream().map(leftNames::get).collect(Collectors.toList());
        List rightKeyNames = rightKeys.stream().map(rightNames::get).collect(Collectors.toList());
        if (!leftKeyNames.equals(rightKeyNames)) {
            throw new IllegalArgumentException(SqlError.lookup(SqlError.EQUIJOINS_ON_FK_ONLY, new Object[0]));
        }
        List<String> rightSidePrimaryKeys = Streams.concat((Stream[])new Stream[]{right.getColumns().stream()}).filter(DocumentDbSchemaColumn::isPrimaryKey).map(c -> c.isIndex() ? c.getSqlName() : c.getFieldPath()).distinct().sorted().collect(Collectors.toList());
        List<String> leftSidePrimaryKeys = Streams.concat((Stream[])new Stream[]{left.getColumns().stream()}).filter(DocumentDbSchemaColumn::isPrimaryKey).map(c -> c.isIndex() ? c.getSqlName() : c.getFieldPath()).distinct().sorted().collect(Collectors.toList());
        Collections.sort(leftKeyNames);
        this.validateMinimumPrimaryKeysUsage(leftKeyNames, leftSidePrimaryKeys, rightSidePrimaryKeys);
    }

    protected void validateMinimumPrimaryKeysUsage(List<String> keyNames, List<String> leftSidePrimaryKeys, List<String> rightSidePrimaryKeys) {
        leftSidePrimaryKeys.retainAll(rightSidePrimaryKeys);
        if (!keyNames.containsAll(leftSidePrimaryKeys)) {
            ArrayList<String> keysMissing = new ArrayList<String>(leftSidePrimaryKeys);
            keysMissing.removeAll(keyNames);
            throw new IllegalArgumentException(SqlError.lookup(SqlError.JOIN_MISSING_PRIMARY_KEYS, keysMissing));
        }
    }

    private void joinDifferentCollections(DocumentDbRel.Implementor implementor, DocumentDbRel.Implementor rightImplementor, String leftCollectionName, String rightCollectionName, DocumentDbSchemaTable leftTable, DocumentDbSchemaTable rightTable) {
        DocumentDbToEnumerableConverter.handleVirtualTable(rightImplementor);
        this.validateDifferentCollectionJoin();
        String rightMatches = rightTable.getSqlName();
        LinkedHashMap<String, DocumentDbSchemaColumn> leftColumns = this.getRequiredColumns(leftTable, () -> ((DocumentDbJoin)this).getLeft());
        LinkedHashMap<String, DocumentDbSchemaColumn> rightColumns = this.getRequiredColumns(rightTable, () -> ((DocumentDbJoin)this).getRight());
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>(leftColumns);
        LinkedHashSet<String> usedKeys = new LinkedHashSet<String>(columnMap.keySet());
        for (Map.Entry entry : rightColumns.entrySet()) {
            String key = SqlValidatorUtil.uniquify((String)((String)entry.getKey()), usedKeys, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
            DocumentDbSchemaColumn oldColumn = (DocumentDbSchemaColumn)entry.getValue();
            DocumentDbMetadataColumn newColumn = DocumentDbMetadataColumn.builder().sqlName(oldColumn.getSqlName()).fieldPath(oldColumn.getFieldPath()).dbType(oldColumn.getDbType()).isPrimaryKey(oldColumn.isPrimaryKey()).isIndex(oldColumn.isIndex()).foreignKeyColumnName(oldColumn.getForeignKeyColumnName()).foreignKeyTableName(oldColumn.getForeignKeyTableName()).resolvedPath(DocumentDbTableSchemaGeneratorHelper.combinePath(rightMatches, DocumentDbRules.getPath(oldColumn, false))).build();
            columnMap.put(key, newColumn);
        }
        DocumentDbMetadataTable metadata = DocumentDbMetadataTable.builder().sqlName(leftCollectionName).columns(columnMap).build();
        DocumentDbTable joinedTable = new DocumentDbTable(leftCollectionName, metadata);
        implementor.setDocumentDbTable(joinedTable);
        implementor.setMetadataTable(metadata);
        JsonBuilder jsonBuilder = new JsonBuilder();
        LinkedHashMap lookupMap = new LinkedHashMap();
        LinkedHashMap<String, Object> lookupFields = new LinkedHashMap<String, Object>();
        lookupFields.put("from", rightCollectionName);
        Map<String, String> letExpressions = leftColumns.values().stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, column -> "$" + DocumentDbRules.getPath(column, false)));
        lookupFields.put("let", letExpressions);
        ArrayList<Map> stages = new ArrayList<Map>();
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true)).build();
        for (Pair<String, String> operations : rightImplementor.getList()) {
            String stage = (String)operations.right;
            Map map = (Map)mapper.readValue(stage, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            stages.add(map);
        }
        JoinTranslator translator = new JoinTranslator(implementor.getRexBuilder(), leftColumns, rightColumns);
        stages.add(translator.translateMatch(this.getCondition()));
        lookupFields.put("pipeline", stages);
        lookupFields.put("as", rightMatches);
        lookupMap.put("$lookup", lookupFields);
        implementor.add(null, jsonBuilder.toJsonString(lookupMap));
        UnwindOptions opts = new UnwindOptions();
        switch (this.getJoinType()) {
            case INNER: {
                opts.preserveNullAndEmptyArrays(Boolean.valueOf(false));
                break;
            }
            case LEFT: {
                opts.preserveNullAndEmptyArrays(Boolean.valueOf(true));
                break;
            }
            default: {
                throw new IllegalArgumentException(SqlError.lookup(SqlError.UNSUPPORTED_JOIN_TYPE, this.getJoinType().name()));
            }
        }
        implementor.add(null, String.valueOf(Aggregates.unwind((String)("$" + rightMatches), (UnwindOptions)opts)));
        LOGGER.debug("Created join stages of pipeline.");
        LOGGER.debug("Pipeline stages added: {}", implementor.getList().stream().map(c -> (String)c.right).toArray());
    }

    private void validateDifferentCollectionJoin() {
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        ArrayList nonEquiList = new ArrayList();
        ArrayList filterNulls = new ArrayList();
        RelOptUtil.splitJoinCondition((RelNode)this.getLeft(), (RelNode)this.getRight(), (RexNode)this.getCondition(), leftKeys, rightKeys, filterNulls, nonEquiList);
        if (!nonEquiList.isEmpty() || leftKeys.size() != 1 || rightKeys.size() != 1) {
            throw new IllegalArgumentException(SqlError.lookup(SqlError.SINGLE_EQUIJOIN_ONLY, new Object[0]));
        }
    }

    private LinkedHashMap<String, DocumentDbSchemaColumn> getRequiredColumns(DocumentDbSchemaTable table, Supplier<RelNode> getNode) {
        List fieldNames = getNode.get().getRowType().getFieldNames();
        return table.getColumnMap().entrySet().stream().filter(entry -> fieldNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }

    private static class JoinTranslator {
        private final RexBuilder rexBuilder;
        private final List<String> fieldNames;

        JoinTranslator(RexBuilder rexBuilder, Map<String, DocumentDbSchemaColumn> leftColumns, Map<String, DocumentDbSchemaColumn> rightColumns) {
            this.rexBuilder = rexBuilder;
            List leftFieldNames = leftColumns.values().stream().map(column -> "$$" + column.getSqlName()).collect(Collectors.toList());
            List rightFieldNames = rightColumns.values().stream().map(column -> "$" + DocumentDbRules.getPath(column, false)).collect(Collectors.toList());
            this.fieldNames = Stream.concat(leftFieldNames.stream(), rightFieldNames.stream()).collect(Collectors.toList());
        }

        private Map<String, Object> translateMatch(RexNode condition) {
            LinkedHashMap<String, Object> matchMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> exprMap = new LinkedHashMap<String, Object>();
            exprMap.put("$expr", this.translateOr(condition));
            matchMap.put("$match", exprMap);
            return matchMap;
        }

        private Object translateOr(RexNode condition) {
            RexNode condition2 = RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)condition);
            ArrayList<Object> list = new ArrayList<Object>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition2)) {
                list.add(this.translateAnd(node));
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            LinkedHashMap<String, ArrayList<Object>> map = new LinkedHashMap<String, ArrayList<Object>>();
            map.put("$or", list);
            return map;
        }

        private Object translateAnd(RexNode node0) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (RexNode node : RelOptUtil.conjunctions((RexNode)node0)) {
                list.add(this.translateMatch2(node));
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            LinkedHashMap<String, ArrayList<Map<String, Object>>> map = new LinkedHashMap<String, ArrayList<Map<String, Object>>>();
            map.put("$and", list);
            return map;
        }

        private Object getValue(RexNode node) {
            switch (node.getKind()) {
                case INPUT_REF: {
                    return this.fieldNames.get(((RexInputRef)node).getIndex());
                }
                case LITERAL: {
                    return ((RexLiteral)node).getValue2();
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Map<String, Object> translateMatch2(RexNode node) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary("$eq", (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("$lt", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("$lte", (RexCall)node);
                }
                case NOT_EQUALS: {
                    return this.translateBinary("$ne", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary("$gt", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary("$gte", (RexCall)node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Map<String, Object> translateBinary(String op, RexCall call) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Object left = this.getValue((RexNode)call.operands.get(0));
            Object right = this.getValue((RexNode)call.operands.get(1));
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(left);
            items.add(right);
            map.put(op, items);
            return map;
        }
    }
}

