/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnection;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbDatabaseMetaData;
import software.amazon.documentdb.jdbc.common.Driver;

public class DocumentDbDriver
extends Driver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbDriver.class);
    private static final String DRIVER_MAJOR_VERSION_KEY = "driver.major.version";
    private static final String DRIVER_MINOR_VERSION_KEY = "driver.minor.version";
    private static final String DRIVER_FULL_VERSION_KEY = "driver.full.version";
    private static final String DEFAULT_APPLICATION_NAME_KEY = "default.application.name";
    private static final String PROPERTIES_FILE_PATH = "/project.properties";
    static final int DRIVER_MAJOR_VERSION;
    static final int DRIVER_MINOR_VERSION;
    static final String DRIVER_VERSION;
    static final String DEFAULT_APPLICATION_NAME;

    protected void register() {
        DriverManager.registerDriver(this);
    }

    @Override
    public @Nullable Connection connect(@Nullable String url, Properties info) throws SQLException {
        DocumentDbConnectionProperties properties;
        if (url == null || !this.acceptsURL(url)) {
            return null;
        }
        try {
            properties = DocumentDbConnectionProperties.getPropertiesFromConnectionString(info, url, this.getConnectStringPrefix());
        }
        catch (IllegalArgumentException exception) {
            throw new SQLException(exception.getMessage(), exception);
        }
        return new DocumentDbConnection(properties);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("The url cannot be null");
        }
        return url.startsWith(this.getConnectStringPrefix());
    }

    protected String getConnectStringPrefix() {
        return "jdbc:documentdb:";
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_MINOR_VERSION;
    }

    static {
        int majorVersion = 0;
        int minorVersion = 0;
        String fullVersion = "";
        String defaultApplicationName = "";
        try (InputStream is = DocumentDbDatabaseMetaData.class.getResourceAsStream(PROPERTIES_FILE_PATH);){
            Properties p = new Properties();
            p.load(is);
            majorVersion = Integer.parseInt(p.getProperty(DRIVER_MAJOR_VERSION_KEY));
            minorVersion = Integer.parseInt(p.getProperty(DRIVER_MINOR_VERSION_KEY));
            fullVersion = p.getProperty(DRIVER_FULL_VERSION_KEY);
            defaultApplicationName = p.getProperty(DEFAULT_APPLICATION_NAME_KEY);
        }
        catch (Exception e) {
            LOGGER.error("Error loading driver version: " + e.getMessage());
        }
        DRIVER_MAJOR_VERSION = majorVersion;
        DRIVER_MINOR_VERSION = minorVersion;
        DRIVER_VERSION = fullVersion;
        DEFAULT_APPLICATION_NAME = defaultApplicationName;
        new DocumentDbDriver().register();
    }
}

