/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.sshtunnel;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbMultiThreadFileChannel;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbSshTunnelLock;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbSshTunnelServer;

public class DocumentDbSshTunnelClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbSshTunnelClient.class);
    private final Object mutex = new Object();
    private final String propertiesHashString;
    private final DocumentDbSshTunnelServer sshTunnelServer;
    private volatile FileLock clientLock = null;
    private volatile DocumentDbMultiThreadFileChannel clientChannel = null;
    private volatile Path clientLockPath = null;

    public DocumentDbSshTunnelClient(@NonNull DocumentDbConnectionProperties properties) throws Exception {
        DocumentDbSshTunnelClient.validateSshTunnelProperties(properties);
        this.propertiesHashString = DocumentDbSshTunnelLock.getHashString(properties.getSshUser(), properties.getSshHostname(), properties.getSshPrivateKeyFile(), properties.getHostname());
        try {
            this.ensureClientLocked();
            this.sshTunnelServer = DocumentDbSshTunnelServer.builder(properties.getSshUser(), properties.getSshHostname(), properties.getSshPrivateKeyFile(), properties.getHostname()).sshPrivateKeyPassphrase(properties.getSshPrivateKeyPassphrase()).sshStrictHostKeyChecking(properties.getSshStrictHostKeyChecking()).sshKnownHostsFile(properties.getSshKnownHostsFile()).build();
            this.sshTunnelServer.addClient();
        }
        catch (Exception e) {
            this.ensureClientUnlocked();
            throw e;
        }
    }

    private static void validateSshTunnelProperties(DocumentDbConnectionProperties properties) throws SQLException {
        if (DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshUser()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshHostname()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshPrivateKeyFile()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getHostname())) {
            throw new IllegalArgumentException();
        }
        DocumentDbSshTunnelServer.validateSshPrivateKeyFile(properties);
        DocumentDbSshTunnelServer.getSshKnownHostsFilename(properties);
    }

    public int getServiceListeningPort() {
        return this.sshTunnelServer.getServiceListeningPort();
    }

    public boolean isServerAlive() throws Exception {
        return this.getSshTunnelServer().isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureClientUnlocked();
            this.sshTunnelServer.removeClient();
        }
    }

    @VisibleForTesting
    @NonNull DocumentDbSshTunnelServer getSshTunnelServer() {
        return this.sshTunnelServer;
    }

    private void ensureClientLocked() throws Exception {
        this.initializeClientLockFolder();
        Exception exception = DocumentDbSshTunnelLock.runInGlobalLock(this.propertiesHashString, this::lockClientFile);
        if (exception != null) {
            throw exception;
        }
    }

    private void initializeClientLockFolder() throws IOException {
        UUID unique = UUID.randomUUID();
        this.clientLockPath = DocumentDbSshTunnelLock.getClientLockPath(unique, this.propertiesHashString);
        Path parentPath = this.clientLockPath.getParent();
        assert (parentPath != null);
        Files.createDirectories(parentPath, new FileAttribute[0]);
    }

    private Exception lockClientFile() {
        Exception e = null;
        try {
            this.clientChannel = DocumentDbMultiThreadFileChannel.open(this.clientLockPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.clientLock = this.clientChannel.lock();
            LOGGER.debug("SSH Tunnel server client lock active.");
        }
        catch (Exception ex) {
            e = ex;
        }
        return e;
    }

    private void ensureClientUnlocked() throws Exception {
        Exception exception = DocumentDbSshTunnelLock.runInGlobalLock(this.propertiesHashString, this::unlockClientFile);
        if (exception != null) {
            throw exception;
        }
    }

    private Exception unlockClientFile() {
        Exception exception = null;
        try {
            if (this.clientLock != null && this.clientLock.isValid()) {
                this.clientLock.close();
                LOGGER.debug("SSH Tunnel server client lock inactive.");
            }
            if (this.clientChannel != null && this.clientChannel.isOpen()) {
                this.clientChannel.close();
            }
            if (this.clientLockPath != null) {
                Files.deleteIfExists(this.clientLockPath);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        this.clientLock = null;
        this.clientChannel = null;
        this.clientLockPath = null;
        return exception;
    }
}

