/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import org.bson.BsonType;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;

@JsonSerialize(as=DocumentDbSchemaColumn.class)
public class DocumentDbMetadataColumn
extends DocumentDbSchemaColumn {
    private int index;
    private int primaryKeyIndex;
    private int foreignKeyIndex;
    private final Integer arrayIndexLevel;
    private final String tableName;
    private final String virtualTableName;
    private final String resolvedPath;
    private final boolean isGenerated;

    public DocumentDbMetadataColumn(int index, int primaryKeyIndex, int foreignKeyIndex, Integer arrayIndexLevel, String virtualTableName, String tableName, String resolvedPath, boolean isGenerated, String fieldPath, String sqlName, JdbcType sqlType, BsonType dbType, boolean isIndex, boolean isPrimaryKey, String foreignKeyTableName, String foreignKeyColumnName) {
        super(fieldPath, sqlName, sqlType, dbType, isIndex, isPrimaryKey, foreignKeyTableName, foreignKeyColumnName);
        this.index = index;
        this.primaryKeyIndex = primaryKeyIndex;
        this.foreignKeyIndex = foreignKeyIndex;
        this.arrayIndexLevel = arrayIndexLevel;
        this.tableName = tableName;
        this.virtualTableName = virtualTableName;
        this.resolvedPath = resolvedPath;
        this.isGenerated = isGenerated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDbMetadataColumn)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DocumentDbMetadataColumn that = (DocumentDbMetadataColumn)o;
        return this.index == that.index && this.primaryKeyIndex == that.primaryKeyIndex && this.foreignKeyIndex == that.foreignKeyIndex && this.isGenerated == that.isGenerated && Objects.equals(this.arrayIndexLevel, that.arrayIndexLevel) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.virtualTableName, that.virtualTableName) && Objects.equals(this.resolvedPath, that.resolvedPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index, this.primaryKeyIndex, this.foreignKeyIndex, this.arrayIndexLevel, this.tableName, this.virtualTableName, this.resolvedPath, this.isGenerated);
    }

    public static DocumentDbMetadataColumnBuilder builder() {
        return new DocumentDbMetadataColumnBuilder();
    }

    public int getIndex() {
        return this.index;
    }

    public int getPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    public int getForeignKeyIndex() {
        return this.foreignKeyIndex;
    }

    public Integer getArrayIndexLevel() {
        return this.arrayIndexLevel;
    }

    public String getVirtualTableName() {
        return this.virtualTableName;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    String getTableName() {
        return this.tableName;
    }

    public static class DocumentDbMetadataColumnBuilder {
        private int index;
        private int primaryKeyIndex;
        private int foreignKeyIndex;
        private Integer arrayIndexLevel;
        private String virtualTableName;
        private String tableName;
        private String resolvedPath;
        private boolean isGenerated;
        private String fieldPath;
        private String sqlName;
        private JdbcType sqlType;
        private BsonType dbType;
        private boolean isIndex;
        private boolean isPrimaryKey;
        private String foreignKeyTableName;
        private String foreignKeyColumnName;

        DocumentDbMetadataColumnBuilder() {
        }

        public DocumentDbMetadataColumnBuilder index(int index) {
            this.index = index;
            return this;
        }

        public DocumentDbMetadataColumnBuilder primaryKeyIndex(int primaryKeyIndex) {
            this.primaryKeyIndex = primaryKeyIndex;
            return this;
        }

        public DocumentDbMetadataColumnBuilder foreignKeyIndex(int foreignKeyIndex) {
            this.foreignKeyIndex = foreignKeyIndex;
            return this;
        }

        public DocumentDbMetadataColumnBuilder arrayIndexLevel(Integer arrayIndexLevel) {
            this.arrayIndexLevel = arrayIndexLevel;
            return this;
        }

        public DocumentDbMetadataColumnBuilder virtualTableName(String virtualTableName) {
            this.virtualTableName = virtualTableName;
            return this;
        }

        public DocumentDbMetadataColumnBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DocumentDbMetadataColumnBuilder resolvedPath(String resolvedPath) {
            this.resolvedPath = resolvedPath;
            return this;
        }

        public DocumentDbMetadataColumnBuilder isGenerated(boolean isGenerated) {
            this.isGenerated = isGenerated;
            return this;
        }

        public DocumentDbMetadataColumnBuilder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public DocumentDbMetadataColumnBuilder sqlName(String sqlName) {
            this.sqlName = sqlName;
            return this;
        }

        public DocumentDbMetadataColumnBuilder sqlType(JdbcType sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        public DocumentDbMetadataColumnBuilder dbType(BsonType dbType) {
            this.dbType = dbType;
            return this;
        }

        public DocumentDbMetadataColumnBuilder isIndex(boolean isIndex) {
            this.isIndex = isIndex;
            return this;
        }

        public DocumentDbMetadataColumnBuilder isPrimaryKey(boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public DocumentDbMetadataColumnBuilder foreignKeyTableName(String foreignKeyTableName) {
            this.foreignKeyTableName = foreignKeyTableName;
            return this;
        }

        public DocumentDbMetadataColumnBuilder foreignKeyColumnName(String foreignKeyColumnName) {
            this.foreignKeyColumnName = foreignKeyColumnName;
            return this;
        }

        public DocumentDbMetadataColumn build() {
            return new DocumentDbMetadataColumn(this.index, this.primaryKeyIndex, this.foreignKeyIndex, this.arrayIndexLevel, this.virtualTableName, this.tableName, this.resolvedPath, this.isGenerated, this.fieldPath, this.sqlName, this.sqlType, this.dbType, this.isIndex, this.isPrimaryKey, this.foreignKeyTableName, this.foreignKeyColumnName);
        }

        public String toString() {
            return "DocumentDbMetadataColumn.DocumentDbMetadataColumnBuilder(index=" + this.index + ", primaryKeyIndex=" + this.primaryKeyIndex + ", foreignKeyIndex=" + this.foreignKeyIndex + ", arrayIndexLevel=" + this.arrayIndexLevel + ", virtualTableName=" + this.virtualTableName + ", tableName=" + this.tableName + ", resolvedPath=" + this.resolvedPath + ", isGenerated=" + this.isGenerated + ", fieldPath=" + this.fieldPath + ", sqlName=" + this.sqlName + ", sqlType=" + (Object)((Object)this.sqlType) + ", dbType=" + this.dbType + ", isIndex=" + this.isIndex + ", isPrimaryKey=" + this.isPrimaryKey + ", foreignKeyTableName=" + this.foreignKeyTableName + ", foreignKeyColumnName=" + this.foreignKeyColumnName + ")";
        }
    }
}

