/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common.utilities;

import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public enum SqlError {
    AFTER_LAST,
    AUTHORIZATION_ERROR,
    BEFORE_FIRST,
    CANNOT_UNWRAP,
    CANNOT_RETRIEVE_COLUMN,
    CONN_CLOSED,
    CREATE_FOLDER_FAILED,
    DELETE_SCHEMA_FAILED,
    DELETE_TABLE_SCHEMA_FAILED,
    DELETE_TABLE_SCHEMA_INCONSISTENT,
    EQUIJOINS_ON_FK_ONLY,
    INCONSISTENT_SCHEMA,
    INVALID_COLUMN_LABEL,
    INVALID_CONNECTION_PROPERTIES,
    INVALID_FETCH_SIZE,
    INVALID_FORMAT,
    INVALID_LARGE_MAX_ROWS_SIZE,
    INVALID_MAX_FIELD_SIZE,
    INVALID_ROW_VALUE,
    INVALID_INDEX,
    INVALID_TIMEOUT,
    INVALID_STATE_SET_TABLE_FUNCTION,
    JOIN_MISSING_PRIMARY_KEYS,
    KNOWN_HOSTS_FILE_NOT_FOUND,
    MISSING_DATABASE,
    MISSING_HOSTNAME,
    MISSING_JAVA_HOME,
    MISSING_JAVA_BIN,
    MISSING_SCHEMA,
    MISSING_PASSWORD,
    MISSING_SSH_USER,
    MISSING_SSH_HOSTNAME,
    MISSING_SSH_PRIVATE_KEY_FILE,
    MISSING_USER_PASSWORD,
    MISSING_LITERAL_VALUE,
    MISMATCH_SCHEMA_NAME,
    PARAMETERS_NOT_SUPPORTED,
    PASSWORD_PROMPT,
    POOLING_NOT_SUPPORTED,
    QUERY_CANCELED,
    QUERY_CANNOT_BE_CANCELED,
    QUERY_FAILED,
    QUERY_IN_PROGRESS,
    QUERY_NOT_STARTED_OR_COMPLETE,
    READ_ONLY,
    RESULT_FORWARD_ONLY,
    RESULT_SET_CLOSED,
    SECURITY_ERROR,
    SSH_PRIVATE_KEY_FILE_NOT_FOUND,
    SSH_TUNNEL_PATH_NOT_FOUND,
    SINGLE_EQUIJOIN_ONLY,
    SQL_PARSE_ERROR,
    SSH_TUNNEL_ERROR,
    STMT_CLOSED,
    TLS_CA_FILE_NOT_FOUND,
    TRANSACTIONS_NOT_SUPPORTED,
    UPSERT_SCHEMA_FAILED,
    UNSUPPORTED_CONVERSION,
    UNSUPPORTED_CROSS_REFERENCE,
    UNSUPPORTED_EXPORTED_KEYS,
    UNSUPPORTED_FETCH_DIRECTION,
    UNSUPPORTED_FUNCTIONS,
    UNSUPPORTED_FUNCTION_COLUMNS,
    UNSUPPORTED_GENERATED_KEYS,
    UNSUPPORTED_JOIN_TYPE,
    UNSUPPORTED_PREPARE_STATEMENT,
    UNSUPPORTED_PREPARE_CALL,
    UNSUPPORTED_PROCEDURE_COLUMNS,
    UNSUPPORTED_PROPERTY,
    UNSUPPORTED_PSEUDO_COLUMNS,
    UNSUPPORTED_REFRESH_ROW,
    UNSUPPORTED_RESULT_SET_TYPE,
    UNSUPPORTED_TABLE_PRIVILEGES,
    UNSUPPORTED_TYPE,
    UNSUPPORTED_SQL,
    UNSUPPORTED_SUPER_TABLES,
    UNSUPPORTED_SUPER_TYPES,
    UNSUPPORTED_USER_DEFINED_TYPES,
    UNSUPPORTED_VERSION_COLUMNS;

    private static final ResourceBundle RESOURCE;

    public static String lookup(SqlError key, Object ... formatArgs) {
        return String.format(RESOURCE.getString(key.name()), formatArgs).replaceAll("[\r\n]", "");
    }

    static String getErrorMessage(Logger logger, SqlError key, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.error(error);
        return error;
    }

    public static SQLException createSQLException(java.util.logging.Logger logger, SqlState sqlState, SqlError key, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.severe(error);
        return new SQLException(error, sqlState.getSqlState());
    }

    public static SQLException createSQLException(Logger logger, SqlState sqlState, SqlError key, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.error(error);
        return new SQLException(error, sqlState.getSqlState());
    }

    public static SQLException createSQLException(Logger logger, SqlState sqlState, Exception exception, SqlError key, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.error(error);
        return new SQLException(error, sqlState.getSqlState(), exception);
    }

    public static SQLFeatureNotSupportedException createSQLFeatureNotSupportedException(Logger logger, SqlError key, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.trace(error);
        return new SQLFeatureNotSupportedException(error);
    }

    public static SQLClientInfoException createSQLClientInfoException(Logger logger, SqlError key, Map<String, ClientInfoStatus> map, Object ... formatArgs) {
        String error = SqlError.lookup(key, formatArgs);
        logger.error(error);
        return new SQLClientInfoException(error, map);
    }

    static {
        RESOURCE = ResourceBundle.getBundle("jdbc");
    }
}

