/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbAggregate
extends Aggregate
implements DocumentDbRel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbAggregate.class.getName());

    public DocumentDbAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, (List)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() == CONVENTION);
        assert (this.getConvention() == input.getConvention());
        switch (this.getGroupType()) {
            case SIMPLE: {
                break;
            }
            default: {
                throw new InvalidRelException("unsupported group type: " + this.getGroupType());
            }
        }
    }

    @Deprecated
    public DocumentDbAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        DocumentDbAggregate.checkIndicator((boolean)indicator);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new DocumentDbAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        Object inName;
        implementor.visitChild(0, this.getInput());
        ArrayList<String> list = new ArrayList<String>();
        DocumentDbRel.Implementor mongoImplementor = new DocumentDbRel.Implementor(implementor.getRexBuilder());
        mongoImplementor.visitChild(0, this.getInput());
        List<String> mongoFieldNames = DocumentDbRules.mongoFieldNames(this.getInput().getRowType(), mongoImplementor.getMetadataTable());
        List inNames = this.getInput().getRowType().getFieldNames();
        List outNames = this.getRowType().getFieldNames();
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>((Map<String, DocumentDbSchemaColumn>)implementor.getMetadataTable().getColumnMap());
        int columnIndex = 0;
        if (this.groupSet.cardinality() == 1) {
            String outName = (String)outNames.get(columnIndex);
            inName = (String)inNames.get(this.groupSet.nth(0));
            String fieldName = mongoFieldNames.get(this.groupSet.nth(0));
            DocumentDbSchemaColumn oldColumn = (DocumentDbSchemaColumn)implementor.getMetadataTable().getColumnMap().get(inName);
            list.add("_id: " + DocumentDbRules.maybeQuote("$" + fieldName));
            assert (oldColumn != null);
            columnMap.put(outName, DocumentDbAggregate.getUpdatedColumn(oldColumn, outName));
            ++columnIndex;
        } else {
            ArrayList keys = new ArrayList();
            inName = this.groupSet.iterator();
            while (inName.hasNext()) {
                int group = (Integer)inName.next();
                String outName = (String)outNames.get(columnIndex);
                String inName2 = (String)inNames.get(group);
                String fieldName = mongoFieldNames.get(group);
                DocumentDbSchemaColumn oldColumn = (DocumentDbSchemaColumn)implementor.getMetadataTable().getColumnMap().get((Object)inName2);
                keys.add(DocumentDbRules.maybeQuote(DocumentDbAggregate.acceptedMongoFieldName(outName)) + ": " + DocumentDbRules.quote("$" + fieldName));
                assert (oldColumn != null);
                columnMap.put(outName, DocumentDbAggregate.getUpdatedColumn(oldColumn, outName));
                ++columnIndex;
            }
            list.add("_id: " + Util.toString(keys, (String)"{", (String)", ", (String)"}"));
        }
        for (AggregateCall aggCall2 : this.aggCalls) {
            String outName = (String)outNames.get(columnIndex++);
            list.add(DocumentDbRules.maybeQuote(DocumentDbAggregate.acceptedMongoFieldName(outName)) + ": " + DocumentDbAggregate.toMongo(aggCall2.getAggregation(), mongoFieldNames, aggCall2.getArgList(), aggCall2.isDistinct()));
            columnMap.put(outName, DocumentDbMetadataColumn.builder().isGenerated(true).fieldPath(DocumentDbAggregate.acceptedMongoFieldName(outName)).sqlName(outName).build());
        }
        implementor.add(null, "{$group: " + Util.toString(list, (String)"{", (String)", ", (String)"}") + "}");
        List<String> fixups = DocumentDbAggregate.getFixups(this.aggCalls, this.groupSet, outNames);
        if (!this.groupSet.isEmpty() || this.aggCalls.stream().anyMatch(aggCall -> aggCall.isDistinct() || aggCall.getAggregation() == SqlStdOperatorTable.SUM)) {
            implementor.add(null, "{$project: " + Util.toString(fixups, (String)"{", (String)", ", (String)"}") + "}");
        }
        DocumentDbSchemaTable oldMetadata = implementor.getMetadataTable();
        DocumentDbMetadataTable metadata = DocumentDbMetadataTable.builder().sqlName(oldMetadata.getSqlName()).collectionName(oldMetadata.getCollectionName()).columns(columnMap).build();
        implementor.setMetadataTable(metadata);
        implementor.setDocumentDbTable(new DocumentDbTable(implementor.getDocumentDbTable().getCollectionName(), metadata));
        LOGGER.info("Created aggregation stages of pipeline.");
        LOGGER.debug("Pipeline stages added: {}", implementor.getList().stream().map(c -> (String)c.right).toArray());
    }

    private static DocumentDbSchemaColumn getUpdatedColumn(DocumentDbSchemaColumn oldColumn, String outName) {
        return DocumentDbMetadataColumn.builder().fieldPath(oldColumn.getFieldPath()).sqlName(oldColumn.getSqlName()).sqlType(oldColumn.getSqlType()).dbType(oldColumn.getDbType()).isIndex(oldColumn.isIndex()).isPrimaryKey(oldColumn.isPrimaryKey()).foreignKeyTableName(oldColumn.getForeignKeyTableName()).foreignKeyColumnName(oldColumn.getForeignKeyColumnName()).resolvedPath(DocumentDbAggregate.acceptedMongoFieldName(outName)).build();
    }

    private static String toMongo(SqlAggFunction aggregation, List<String> inNames, List<Integer> args, boolean isDistinct) {
        if (!(args.isEmpty() && aggregation == SqlStdOperatorTable.COUNT || args.size() == 1)) {
            throw new AssertionError((Object)("aggregate with incorrect number of arguments: " + aggregation));
        }
        if (isDistinct) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$addToSet: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            if (args.isEmpty()) {
                return "{$sum: 1}";
            }
            String inName = inNames.get(args.get(0));
            return "{$sum: {$cond: [ {$gt: [" + DocumentDbRules.maybeQuote("$" + inName) + ", null]}, 1, 0]}}";
        }
        if (aggregation == SqlStdOperatorTable.SUM) {
            String inName = inNames.get(args.get(0));
            return "{$push: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.SUM0) {
            String inName = inNames.get(args.get(0));
            return "{$sum: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MIN) {
            String inName = inNames.get(args.get(0));
            return "{$min: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MAX) {
            String inName = inNames.get(args.get(0));
            return "{$max: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.AVG) {
            String inName = inNames.get(args.get(0));
            return "{$avg: " + DocumentDbRules.maybeQuote("$" + inName) + "}";
        }
        throw new AssertionError((Object)("unknown aggregate " + aggregation));
    }

    private static String acceptedMongoFieldName(String path) {
        return DocumentDbRules.getNormalizedIdentifier(path).replace('.', '_');
    }

    private static String setToAggregate(SqlAggFunction aggFunction, String outName) {
        if (aggFunction == SqlStdOperatorTable.COUNT) {
            return "{$size: {$filter: {input:" + DocumentDbRules.maybeQuote("$" + outName) + ", cond: { $gt: [ '$$this', null]}}}}";
        }
        if (aggFunction == SqlStdOperatorTable.AVG) {
            return "{$avg: " + DocumentDbRules.maybeQuote("$" + outName) + " }";
        }
        if (aggFunction == SqlStdOperatorTable.SUM) {
            return DocumentDbAggregate.arrayToSum(outName);
        }
        if (aggFunction == SqlStdOperatorTable.SUM0) {
            return "{$sum: " + DocumentDbRules.maybeQuote("$" + outName) + " }";
        }
        throw new AssertionError((Object)("unknown distinct aggregate" + aggFunction));
    }

    private static String arrayToSum(String outName) {
        return String.format("{$cond: [ {$gt: [ {$size: {$filter: {input: %1$s, cond: { $gt: [ '$$this', null]}}}}, 0]}, {$sum:  %1$s }, null]}", DocumentDbRules.maybeQuote("$" + outName));
    }

    private static List<String> getFixups(List<AggregateCall> aggCalls, ImmutableBitSet groupSet, List<String> outNames) {
        String outName;
        ArrayList<String> fixups = new ArrayList<String>();
        int columnIndex = 0;
        if (groupSet.cardinality() == 1) {
            fixups.add(DocumentDbRules.maybeQuote(outNames.get(columnIndex++)) + ": " + DocumentDbRules.maybeQuote("$_id"));
        } else {
            fixups.add("_id: 0");
            Iterator<AggregateCall> iterator = groupSet.iterator();
            while (iterator.hasNext()) {
                int group = (Integer)iterator.next();
                outName = DocumentDbAggregate.acceptedMongoFieldName(outNames.get(columnIndex++));
                fixups.add(DocumentDbRules.maybeQuote(outName) + ": " + DocumentDbRules.maybeQuote("$_id." + DocumentDbAggregate.acceptedMongoFieldName(outName)));
            }
        }
        for (AggregateCall aggCall : aggCalls) {
            outName = DocumentDbAggregate.acceptedMongoFieldName(outNames.get(columnIndex++));
            if (aggCall.isDistinct()) {
                fixups.add(DocumentDbRules.maybeQuote(outName) + ": " + DocumentDbAggregate.setToAggregate(aggCall.getAggregation(), outName));
                continue;
            }
            if (aggCall.getAggregation() == SqlStdOperatorTable.SUM) {
                fixups.add(DocumentDbRules.maybeQuote(outName) + ": " + DocumentDbAggregate.arrayToSum(outName));
                continue;
            }
            fixups.add(DocumentDbRules.maybeQuote(outName) + ": " + DocumentDbRules.maybeQuote("$" + outName));
        }
        return fixups;
    }
}

