/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import software.amazon.documentdb.jdbc.DocumentDbAbstractResultSet;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;

class DocumentDbListResultSet
extends DocumentDbAbstractResultSet {
    private final List<List<Object>> metaData;
    private final int rowCount;
    private int rowIndex = -1;

    DocumentDbListResultSet(Statement statement, ImmutableList<JdbcColumnMetaData> columnMetaData, List<List<Object>> metaData) {
        super(statement, columnMetaData);
        this.metaData = metaData;
        this.rowCount = metaData.size();
    }

    @Override
    protected Object getValue(int columnIndex) {
        return this.metaData.get(this.getRowIndex()).get(columnIndex - 1);
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected int getDriverFetchSize() {
        return 0;
    }

    @Override
    protected void setDriverFetchSize(int rows) {
    }

    @Override
    protected int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    protected int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean next() throws SQLException {
        this.verifyOpen();
        if (this.getRowIndex() < this.getRowCount()) {
            ++this.rowIndex;
        }
        return this.getRowIndex() < this.getRowCount();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.getRowIndex() < 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.getRowIndex() >= this.getRowCount();
    }

    @Override
    public boolean isFirst() {
        return this.rowIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.getRowIndex() == this.getRowCount() - 1;
    }

    @Override
    public void beforeFirst() {
        this.rowIndex = -1;
    }

    @Override
    public void afterLast() {
        this.rowIndex = this.getRowCount();
    }

    @Override
    public boolean first() {
        this.rowIndex = 0;
        return this.getRowIndex() < this.getRowCount();
    }

    @Override
    public boolean last() {
        this.rowIndex = this.getRowCount() - 1;
        return this.getRowIndex() >= 0;
    }

    @Override
    public boolean absolute(int row) {
        if (row > 0 && row < this.getRowCount()) {
            this.rowIndex = row - 1;
            return true;
        }
        if (row < 0) {
            if (this.getRowCount() + row >= 0) {
                this.rowIndex = this.getRowCount() + row;
                return true;
            }
            return false;
        }
        this.rowIndex = -1;
        return false;
    }

    @Override
    public boolean relative(int rows) {
        int proposedRowIndex = this.getRowIndex() + rows;
        if (proposedRowIndex < 0) {
            this.rowIndex = -1;
            return false;
        }
        if (proposedRowIndex >= this.getRowCount()) {
            this.rowIndex = this.getRowCount();
            return false;
        }
        this.rowIndex = proposedRowIndex;
        return true;
    }

    @Override
    public boolean previous() {
        if (this.getRowIndex() >= 0) {
            --this.rowIndex;
        }
        return this.getRowIndex() >= 0;
    }

    @Override
    public int getType() {
        return 1004;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }
}

