/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperty;
import software.amazon.documentdb.jdbc.DocumentDbDatabaseMetaData;
import software.amazon.documentdb.jdbc.DocumentDbPreparedStatement;
import software.amazon.documentdb.jdbc.DocumentDbStatement;
import software.amazon.documentdb.jdbc.common.Connection;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbDatabaseSchemaMetadata;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbSshTunnelClient;

public class DocumentDbConnection
extends Connection
implements java.sql.Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbConnection.class.getName());
    private static final Set<String> SECRET_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(DocumentDbConnectionProperty.PASSWORD.getName(), DocumentDbConnectionProperty.PASSWORD.getName())));
    private final DocumentDbConnectionProperties connectionProperties;
    private DocumentDbDatabaseMetaData metadata;
    private DocumentDbDatabaseSchemaMetadata databaseMetadata;
    private MongoClient mongoClient = null;
    private MongoDatabase mongoDatabase = null;
    private DocumentDbSshTunnelClient sshTunnelClient;

    DocumentDbConnection(DocumentDbConnectionProperties connectionProperties) throws SQLException {
        super(connectionProperties);
        this.connectionProperties = connectionProperties;
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Creating connection with following properties:");
            for (String propertyName : connectionProperties.stringPropertyNames()) {
                if (SECRET_PROPERTIES.contains(propertyName)) continue;
                sb.append(String.format("%n        Connection property %s=%s", propertyName, connectionProperties.get(propertyName).toString()));
            }
            LOGGER.debug(sb.toString());
        }
        if (connectionProperties.enableSshTunnel()) {
            this.ensureSshTunnel(connectionProperties);
        } else {
            LOGGER.debug("Internal SSH tunnel not used.");
        }
        this.initializeClients(connectionProperties);
    }

    private void ensureSshTunnel(DocumentDbConnectionProperties connectionProperties) throws SQLException {
        try {
            this.sshTunnelClient = new DocumentDbSshTunnelClient(connectionProperties);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_EXCEPTION, e, SqlError.SSH_TUNNEL_ERROR, e.getMessage());
        }
    }

    public int getSshLocalPort() {
        if (this.isSshTunnelActive()) {
            return this.sshTunnelClient.getServiceListeningPort();
        }
        return 0;
    }

    public boolean isSshTunnelActive() {
        return this.sshTunnelClient != null && this.sshTunnelClient.getServiceListeningPort() > 0;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_PARAMETER_VALUE, SqlError.INVALID_TIMEOUT, timeout);
        }
        if (this.mongoDatabase != null) {
            try {
                long maxTimeMS = TimeUnit.SECONDS.toMillis(timeout);
                this.pingDatabase(maxTimeMS);
                return true;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void doClose() throws SQLException {
        if (this.mongoDatabase != null) {
            this.mongoDatabase = null;
        }
        if (this.mongoClient != null) {
            this.mongoClient.close();
            this.mongoClient = null;
        }
        if (this.sshTunnelClient != null) {
            try {
                this.sshTunnelClient.close();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_EXCEPTION, e, SqlError.SSH_TUNNEL_ERROR, e.getMessage());
            }
            finally {
                this.sshTunnelClient = null;
            }
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureDatabaseMetadata();
        return this.metadata;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private void ensureDatabaseMetadata() throws SQLException {
        if (this.metadata == null) {
            int version;
            if (this.connectionProperties.getRefreshSchema().booleanValue()) {
                version = -1;
                LOGGER.warn("The '{}' option is enabled and will cause a new version of the SQL schema to be generated. This can lead to poor performance. Please disable this option when it is no longer needed.", (Object)DocumentDbConnectionProperty.REFRESH_SCHEMA.getName());
            } else {
                version = 0;
            }
            this.setMetadata(version);
        }
    }

    private void setMetadata(int version) throws SQLException {
        this.databaseMetadata = DocumentDbDatabaseSchemaMetadata.get(this.connectionProperties, this.connectionProperties.getSchemaName(), version, this.getMongoClient());
        this.metadata = new DocumentDbDatabaseMetaData(this, this.databaseMetadata, this.connectionProperties);
    }

    void refreshDatabaseMetadata() throws SQLException {
        this.setMetadata(-1);
    }

    DocumentDbDatabaseSchemaMetadata getDatabaseMetadata() throws SQLException {
        this.ensureDatabaseMetadata();
        return this.databaseMetadata;
    }

    @Override
    public String getSchema() {
        return this.connectionProperties.getDatabase();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_RESULT_SET_TYPE, new Object[0]);
        }
        return new DocumentDbStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_RESULT_SET_TYPE, new Object[0]);
        }
        return new DocumentDbPreparedStatement(this, sql);
    }

    @Override
    public boolean isSupportedProperty(String name) {
        return DocumentDbConnectionProperty.isSupportedProperty(name);
    }

    DocumentDbConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    private void initializeClients(DocumentDbConnectionProperties connectionProperties) throws SQLException {
        this.mongoClient = connectionProperties.createMongoClient(this.getSshLocalPort());
        this.mongoDatabase = this.mongoClient.getDatabase(connectionProperties.getDatabase());
        this.pingDatabase();
    }

    private void pingDatabase() throws SQLException {
        this.pingDatabase(0L);
    }

    private void pingDatabase(long maxTimeMS) throws SQLException {
        try {
            String maxTimeMSOption = maxTimeMS > 0L ? String.format(", \"maxTimeMS\" : %d", maxTimeMS) : "";
            this.mongoDatabase.runCommand((Bson)Document.parse((String)String.format("{ \"ping\" : 1 %s }", maxTimeMSOption)));
        }
        catch (MongoSecurityException e) {
            if (e.getCode() == -4 && e.getCause() != null && e.getCause() instanceof MongoCommandException && ((MongoCommandException)e.getCause()).getCode() == 18) {
                throw SqlError.createSQLException(LOGGER, SqlState.INVALID_AUTHORIZATION_SPECIFICATION, (Exception)((Object)e), SqlError.AUTHORIZATION_ERROR, this.mongoDatabase.getName(), e.getCredential().getUserName(), e.getCredential().getSource(), e.getCredential().getMechanism());
            }
            throw SqlError.createSQLException(LOGGER, SqlState.SQL_CLIENT_UNABLE_TO_ESTABLISH_SQL_CONNECTION, (Exception)((Object)e), SqlError.SECURITY_ERROR, e.getMessage());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}

