/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;

public class DocumentDbProject
extends Project
implements DocumentDbRel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbProject.class.getName());
    private static final String ID_FIELD = "_id";

    public DocumentDbProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, projects, rowType);
        assert (this.getConvention() == CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    @Deprecated
    public DocumentDbProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard((int)flags);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new DocumentDbProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.1) : null;
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        DocumentDbRel.Implementor mongoImplementor = new DocumentDbRel.Implementor(implementor.getRexBuilder());
        mongoImplementor.visitChild(0, this.getInput());
        List inNames = this.getInput().getRowType().getFieldNames();
        DocumentDbRules.RexToMongoTranslator translator = new DocumentDbRules.RexToMongoTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), DocumentDbRules.mongoFieldNames(this.getInput().getRowType(), mongoImplementor.getMetadataTable()), inNames, mongoImplementor.getMetadataTable(), implementor.getCurrentTime());
        ArrayList<String> items = new ArrayList<String>();
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>((Map<String, DocumentDbSchemaColumn>)implementor.getMetadataTable().getColumnMap());
        for (Pair pair : this.getNamedProjects()) {
            String outName = DocumentDbRules.getNormalizedIdentifier((String)pair.right);
            RexNode expandedNode = RexUtil.expandSearch((RexBuilder)implementor.getRexBuilder(), null, (RexNode)((RexNode)pair.left));
            DocumentDbRules.Operand expr = (DocumentDbRules.Operand)expandedNode.accept((RexVisitor)translator);
            if (pair.left instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)pair.left;
                String inName = (String)inNames.get(ref.getIndex());
                DocumentDbSchemaColumn oldColumn = (DocumentDbSchemaColumn)implementor.getMetadataTable().getColumnMap().get((Object)inName);
                columnMap.remove(inName);
                if (implementor.isJoin() || this.getRowType().getFieldList().size() > 50) {
                    columnMap.put(outName, oldColumn);
                    continue;
                }
                DocumentDbMetadataColumn newColumn = DocumentDbMetadataColumn.builder().fieldPath(oldColumn.getFieldPath()).sqlName(oldColumn.getSqlName()).sqlType(oldColumn.getSqlType()).dbType(oldColumn.getDbType()).isIndex(oldColumn.isIndex()).isPrimaryKey(oldColumn.isPrimaryKey()).foreignKeyTableName(oldColumn.getForeignKeyTableName()).foreignKeyColumnName(oldColumn.getForeignKeyColumnName()).resolvedPath(outName).build();
                columnMap.put(outName, newColumn);
                items.add(DocumentDbRules.maybeQuote(outName) + ": " + expr);
                continue;
            }
            items.add(DocumentDbRules.maybeQuote(outName) + ": " + expr);
            columnMap.put(outName, DocumentDbMetadataColumn.builder().isGenerated(true).fieldPath(outName).sqlName(outName).build());
        }
        if (!items.isEmpty()) {
            String stageString;
            if (implementor.isJoin() || this.getRowType().getFieldList().size() > 50) {
                stageString = "$addFields";
            } else {
                stageString = "$project";
                if (!this.getRowType().getFieldNames().contains(ID_FIELD)) {
                    items.add("_id: 0");
                }
            }
            String findString = Util.toString(items, (String)"{", (String)", ", (String)"}");
            String aggregateString = "{" + stageString + ": " + findString + "}";
            Pair op = Pair.of((Object)findString, (Object)aggregateString);
            implementor.add((String)op.left, (String)op.right);
        }
        LOGGER.info("Created projection stages of pipeline.");
        LOGGER.debug("Pipeline stages added: {}", implementor.getList().stream().map(c -> (String)c.right).toArray());
        DocumentDbMetadataTable metadata = DocumentDbMetadataTable.builder().sqlName(implementor.getMetadataTable().getSqlName()).collectionName(implementor.getMetadataTable().getCollectionName()).columns(columnMap).build();
        implementor.setMetadataTable(metadata);
        implementor.setDocumentDbTable(new DocumentDbTable(implementor.getDocumentDbTable().getCollectionName(), metadata));
    }
}

