/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import software.amazon.documentdb.jdbc.DocumentDbConnection;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbQueryExecutor;
import software.amazon.documentdb.jdbc.DocumentDbResultSetMetaData;
import software.amazon.documentdb.jdbc.DocumentDbStatement;
import software.amazon.documentdb.jdbc.common.PreparedStatement;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.query.DocumentDbQueryMappingService;

public class DocumentDbPreparedStatement
extends PreparedStatement
implements java.sql.PreparedStatement {
    private int queryTimeout = 0;
    private final DocumentDbQueryExecutor queryExecutor;

    public DocumentDbPreparedStatement(Connection connection, String sql) throws SQLException {
        super(connection, sql);
        DocumentDbConnection documentDbConnection = (DocumentDbConnection)this.getConnection();
        DocumentDbStatement.setDefaultFetchSize(this, documentDbConnection.getConnectionProperties());
        DocumentDbConnectionProperties connectionProperties = documentDbConnection.getConnectionProperties();
        DocumentDbQueryMappingService mappingService = new DocumentDbQueryMappingService(connectionProperties, documentDbConnection.getDatabaseMetadata());
        this.queryExecutor = new DocumentDbQueryExecutor(this, connectionProperties, mappingService, this.getQueryTimeout(), this.getFetchSize());
    }

    @Override
    protected void cancelQuery(boolean isClosing) throws SQLException {
        this.queryExecutor.cancelQuery(isClosing);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.verifyOpen();
        this.queryExecutor.setFetchSize(this.getFetchSize());
        return this.queryExecutor.executeQuery(this.getSql());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.verifyOpen();
        if (this.getResultSet() == null) {
            DocumentDbConnection connection = (DocumentDbConnection)this.getConnection();
            DocumentDbQueryMappingService mappingService = new DocumentDbQueryMappingService(connection.getConnectionProperties(), connection.getDatabaseMetadata());
            return new DocumentDbResultSetMetaData((ImmutableList<JdbcColumnMetaData>)ImmutableList.copyOf(mappingService.get(this.getSql()).getColumnMetaData()));
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.verifyOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.verifyOpen();
        this.queryTimeout = seconds;
        this.queryExecutor.setQueryTimeout(seconds);
    }
}

