/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperty;
import software.amazon.documentdb.jdbc.DocumentDbDriver;
import software.amazon.documentdb.jdbc.DocumentDbPooledConnection;
import software.amazon.documentdb.jdbc.DocumentDbReadPreference;
import software.amazon.documentdb.jdbc.common.DataSource;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class DocumentDbDataSource
extends DataSource {
    private final DocumentDbConnectionProperties properties = new DocumentDbConnectionProperties();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbDriver.class.getName());

    @Override
    public Connection getConnection() throws SQLException {
        this.properties.validateRequiredProperties();
        return DriverManager.getConnection("jdbc:documentdb:", this.properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.setUser(username);
        this.setPassword(password);
        this.properties.validateRequiredProperties();
        return DriverManager.getConnection("jdbc:documentdb:", this.properties);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            this.throwInvalidTimeoutException(seconds);
        }
        this.properties.setLoginTimeout(String.valueOf(seconds));
    }

    @Override
    public int getLoginTimeout() {
        return this.properties.getLoginTimeout();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new DocumentDbPooledConnection(this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new DocumentDbPooledConnection(this.getConnection(user, password));
    }

    public void setUser(String username) {
        this.properties.setUser(username);
    }

    public String getUser() {
        return this.properties.getUser();
    }

    public void setPassword(String password) {
        this.properties.setPassword(password);
    }

    public String getPassword() {
        return this.properties.getPassword();
    }

    public void setDatabase(String database) {
        this.properties.setDatabase(database);
    }

    public String getDatabase() {
        return this.properties.getDatabase();
    }

    public void setHostname(String hostname) {
        this.properties.setHostname(hostname);
    }

    public String getHostname() {
        return this.properties.getHostname();
    }

    public void setReadPreference(DocumentDbReadPreference readPreference) {
        this.properties.setReadPreference(readPreference.getName());
    }

    public DocumentDbReadPreference getReadPreference() {
        return this.properties.getReadPreference();
    }

    public void setApplicationName(String applicationName) {
        this.properties.setApplicationName(applicationName);
    }

    public String getApplicationName() {
        return this.properties.getApplicationName();
    }

    public void setReplicaSet(String replicaSet) {
        if (replicaSet != null && !replicaSet.equals(DocumentDbConnectionProperty.REPLICA_SET.getDefaultValue())) {
            LOGGER.warn(String.format("DocumentDB may not support replica set '%s'.", replicaSet));
        }
        if (replicaSet != null) {
            this.properties.setReplicaSet(replicaSet);
        }
    }

    public String getReplicaSet() {
        return this.properties.getReplicaSet();
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.properties.setTlsEnabled(String.valueOf(tlsEnabled));
    }

    public boolean getTlsEnabled() {
        return this.properties.getTlsEnabled();
    }

    public void setTlsAllowInvalidHostnames(boolean allowInvalidHostnames) {
        this.properties.setTlsAllowInvalidHostnames(String.valueOf(allowInvalidHostnames));
    }

    public boolean getTlsAllowInvalidHosts() {
        return this.properties.getTlsAllowInvalidHostnames();
    }

    public void setRetryReadsEnabled(boolean retryReadsEnabled) {
        this.properties.setRetryReadsEnabled(String.valueOf(retryReadsEnabled));
    }

    public boolean getRetryReadsEnabled() {
        return this.properties.getRetryReadsEnabled();
    }

    private void throwInvalidTimeoutException(long timeout) throws SQLException {
        throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_TIMEOUT, timeout);
    }

    @VisibleForTesting
    void validateRequiredProperties() throws SQLException {
        this.properties.validateRequiredProperties();
    }
}

