/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.Driver;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.common.utilities.Warning;

public abstract class Connection
implements java.sql.Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final Properties connectionProperties;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private Map<String, Class<?>> typeMap = new HashMap();
    private SQLWarning warnings = null;

    protected Connection(@NonNull Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.verifyOpen();
        Properties clientInfo = new Properties();
        clientInfo.putAll((Map<?, ?>)this.connectionProperties);
        clientInfo.putIfAbsent("appName", Driver.APPLICATION_NAME);
        return clientInfo;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.throwIfIsClosed(properties);
        this.connectionProperties.clear();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                String value = properties.getProperty(name);
                this.setClientInfo(name, value);
            }
        }
        LOGGER.debug("Successfully set client info with all properties.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.verifyOpen();
        if (name == null) {
            LOGGER.debug("Null value is passed as name, falling back to get client info with null.");
            return null;
        }
        this.connectionProperties.putIfAbsent("appName", Driver.APPLICATION_NAME);
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.verifyOpen();
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        if (map == null) {
            LOGGER.debug("Null value is passed as conversion map, failing back to an empty hash map.");
            this.typeMap = new HashMap();
        } else {
            this.typeMap = map;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.verifyOpen();
        return sql;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Objects.requireNonNull(name);
        this.throwIfIsClosed(null);
        if (this.isSupportedProperty(name)) {
            if (value != null) {
                this.connectionProperties.put(name, value);
                LOGGER.debug("Successfully set client info with name {{}} and value {{}}", (Object)name, (Object)value);
            } else {
                this.connectionProperties.remove(name);
                LOGGER.debug("Successfully removed client info with name {{}}", (Object)name);
            }
        } else {
            this.addWarning(new SQLWarning(Warning.lookup(Warning.UNSUPPORTED_PROPERTY, name)));
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.CANNOT_UNWRAP, iface.toString());
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.verifyOpen();
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    protected void addWarning(SQLWarning warning) {
        LOGGER.warn(warning.getMessage());
        if (this.warnings == null) {
            this.warnings = warning;
            return;
        }
        this.warnings.setNextWarning(warning);
    }

    protected abstract void doClose() throws SQLException;

    @Override
    public void close() throws SQLException {
        if (!this.isClosed.getAndSet(true)) {
            this.doClose();
        }
    }

    protected void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.CONN_CLOSED, new Object[0]);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Blob.class.toString());
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Clob.class.toString());
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, NClob.class.toString());
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, SQLXML.class.toString());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        LOGGER.debug("Transactions are not supported, do nothing for setAutoCommit.");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!readOnly) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.verifyOpen();
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.verifyOpen();
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_STATEMENT, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_STATEMENT, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_STATEMENT, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_STATEMENT, new Object[0]);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.verifyOpen();
        if (level != 0) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void rollback() throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void commit() throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    public abstract boolean isSupportedProperty(String var1);

    private void throwIfIsClosed(Properties properties) throws SQLClientInfoException {
        if (this.isClosed.get()) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            if (properties != null) {
                for (String name : properties.stringPropertyNames()) {
                    failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                }
            }
            throw SqlError.createSQLClientInfoException(LOGGER, SqlError.CONN_CLOSED, failures, new Object[0]);
        }
    }
}

