/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.common.utilities.LazyLinkedHashMap;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbDatabaseSchemaMetadata;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbSchema
extends AbstractSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbSchema.class);
    private Map<String, Table> tables;
    private final DocumentDbDatabaseSchemaMetadata databaseMetadata;
    private final String databaseName;

    protected DocumentDbSchema(DocumentDbDatabaseSchemaMetadata databaseMetadata, DocumentDbConnectionProperties connectionProperties) {
        this.databaseMetadata = databaseMetadata;
        this.databaseName = connectionProperties.getDatabase();
        this.tables = null;
    }

    protected Map<String, Table> getTableMap() {
        if (this.tables == null) {
            this.tables = new LazyLinkedHashMap<String, Table>(new LinkedHashSet<String>(this.databaseMetadata.getTableSchemaMap().keySet()), this::getDocumentDbTable);
        }
        return this.tables;
    }

    private Table getDocumentDbTable(String tableName) {
        DocumentDbSchemaTable schemaTable = this.databaseMetadata.getTableSchemaMap().get(tableName);
        if (schemaTable == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INCONSISTENT_SCHEMA, tableName);
        }
        return new DocumentDbTable(schemaTable.getCollectionName(), schemaTable);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }
}

