/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbTableSchemaGeneratorHelper;

public class DocumentDbTableSchemaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbTableSchemaGenerator.class);
    private static final String INDEX_COLUMN_NAME_PREFIX = "index_lvl_";
    private static final String VALUE_COLUMN_NAME = "value";

    public static Map<String, DocumentDbSchemaTable> generate(String collectionName, Iterator<BsonDocument> cursor) {
        LinkedHashMap<String, DocumentDbSchemaTable> tableMap = new LinkedHashMap<String, DocumentDbSchemaTable>();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        while (cursor.hasNext()) {
            BsonDocument document = cursor.next();
            DocumentDbTableSchemaGenerator.processDocument(document, tableMap, new ArrayList<DocumentDbMetadataColumn>(), "", collectionName, true, tableNameMap);
        }
        DocumentDbTableSchemaGenerator.filterArrayAndDocumentColumns(tableMap);
        return tableMap;
    }

    private static void filterArrayAndDocumentColumns(LinkedHashMap<String, DocumentDbSchemaTable> tableMap) {
        for (DocumentDbSchemaTable table : tableMap.values()) {
            boolean needsUpdate = table.getColumnMap().values().stream().anyMatch(c -> c.getSqlType() == JdbcType.ARRAY || c.getSqlType() == JdbcType.JAVA_OBJECT);
            if (!needsUpdate) continue;
            LinkedHashMap columns = table.getColumnMap().values().stream().filter(c -> c.getSqlType() != JdbcType.ARRAY && c.getSqlType() != JdbcType.JAVA_OBJECT).collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, c -> c, (o, d) -> o, LinkedHashMap::new));
            if (LOGGER.isDebugEnabled() && !tableMap.containsKey(table.getSqlName())) {
                LOGGER.debug(String.format("Added schema for table %s.", table.getSqlName()));
            }
            tableMap.put(table.getSqlName(), DocumentDbMetadataTable.builder().sqlName(table.getSqlName()).collectionName(table.getCollectionName()).columns(columns).build());
        }
    }

    private static void processDocument(BsonDocument document, Map<String, DocumentDbSchemaTable> tableMap, List<DocumentDbMetadataColumn> foreignKeys, String path, String collectionName, boolean isRootDocument, Map<String, String> tableNameMap) {
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>();
        String tableName = DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(collectionName, path), tableNameMap);
        if (tableMap.containsKey(tableName)) {
            columnMap.putAll((Map<String, DocumentDbSchemaColumn>)tableMap.get(tableName).getColumnMap());
        } else {
            int primaryKeyColumn = 0;
            for (DocumentDbMetadataColumn column : foreignKeys) {
                DocumentDbTableSchemaGenerator.buildForeignKeysFromDocument(columnMap, tableName, ++primaryKeyColumn, column);
            }
        }
        Map<String, String> columnNameMap = columnMap.values().stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, DocumentDbSchemaColumn::getSqlName));
        for (Map.Entry entry : document.entrySet()) {
            JdbcType currentDocType;
            String fieldName = (String)entry.getKey();
            String fieldPath = DocumentDbTableSchemaGeneratorHelper.combinePath(path, fieldName);
            BsonValue bsonValue = (BsonValue)entry.getValue();
            BsonType bsonType = bsonValue.getBsonType();
            boolean isPrimaryKey = isRootDocument && DocumentDbTableSchemaGeneratorHelper.isIdField(fieldName);
            String columnName = DocumentDbTableSchemaGeneratorHelper.getFieldNameIfIsPrimaryKey(collectionName, fieldName, isPrimaryKey, columnNameMap);
            DocumentDbMetadataColumn prevMetadataColumn = columnMap.getOrDefault(columnName, null);
            JdbcType prevSqlType = DocumentDbTableSchemaGeneratorHelper.getPrevSqlTypeOrDefault(prevMetadataColumn);
            JdbcType nextSqlType = DocumentDbTableSchemaGeneratorHelper.getSqlTypeIfIsPrimaryKey(bsonType, prevSqlType, isPrimaryKey);
            if (LOGGER.isDebugEnabled() && !prevSqlType.equals((Object)(currentDocType = DocumentDbTableSchemaGeneratorHelper.getSqlTypeIfIsPrimaryKey(bsonType, JdbcType.NULL, isPrimaryKey))) && prevMetadataColumn != null) {
                LOGGER.debug(String.format("Type conflict in table %s, types %s and %s mapped to %s.", new Object[]{tableName, prevSqlType.name(), currentDocType, nextSqlType.name()}));
            }
            DocumentDbTableSchemaGenerator.processComplexTypes(tableMap, new ArrayList<DocumentDbMetadataColumn>(foreignKeys), collectionName, entry, fieldPath, bsonType, prevMetadataColumn, nextSqlType, tableNameMap);
            DocumentDbMetadataColumn metadataColumn = DocumentDbMetadataColumn.builder().fieldPath(fieldPath).sqlName(columnName).sqlType(nextSqlType).dbType(DocumentDbTableSchemaGenerator.getPromotedBsonType(bsonType, prevMetadataColumn)).isIndex(false).isPrimaryKey(isPrimaryKey).index(DocumentDbTableSchemaGeneratorHelper.getPrevIndexOrDefault(prevMetadataColumn, columnMap.size() + 1)).tableName(tableName).primaryKeyIndex(DocumentDbTableSchemaGeneratorHelper.getPrimaryKeyColumn(isPrimaryKey)).foreignKeyIndex(0).isGenerated(false).virtualTableName(DocumentDbTableSchemaGeneratorHelper.getVirtualTableNameIfIsPrimaryKey(fieldPath, nextSqlType, isPrimaryKey, collectionName, tableNameMap)).build();
            columnMap.put(metadataColumn.getSqlName(), metadataColumn);
            DocumentDbTableSchemaGeneratorHelper.addToForeignKeysIfIsPrimary(foreignKeys, isPrimaryKey, metadataColumn);
        }
        if (isRootDocument) {
            DocumentDbTableSchemaGeneratorHelper.checkVirtualTablePrimaryKeys(tableMap, collectionName, columnMap, columnNameMap);
        }
        DocumentDbMetadataTable metadataTable = DocumentDbMetadataTable.builder().sqlName(tableName).collectionName(collectionName).columns(columnMap).build();
        if (LOGGER.isDebugEnabled() && !tableMap.containsKey(metadataTable.getSqlName())) {
            LOGGER.debug(String.format("Added schema for table %s.", metadataTable.getSqlName()));
        }
        tableMap.put(metadataTable.getSqlName(), metadataTable);
    }

    private static BsonType getPromotedBsonType(BsonType bsonType, DocumentDbMetadataColumn prevMetadataColumn) {
        BsonType returnBsonType = DocumentDbTableSchemaGenerator.isPreviousOfType(prevMetadataColumn, BsonType.OBJECT_ID) && bsonType != BsonType.OBJECT_ID ? BsonType.OBJECT_ID : bsonType;
        return returnBsonType;
    }

    private static boolean isPreviousOfType(DocumentDbMetadataColumn prevMetadataColumn, BsonType testType) {
        return prevMetadataColumn != null && prevMetadataColumn.getDbType() == testType;
    }

    private static void processArray(BsonArray array, Map<String, DocumentDbSchemaTable> tableMap, List<DocumentDbMetadataColumn> foreignKeys, String path, int arrayLevel, String collectionName, Map<String, String> tableNameMap) {
        DocumentDbMetadataColumn indexColumn;
        LinkedHashMap<String, DocumentDbSchemaColumn> columnMap = new LinkedHashMap<String, DocumentDbSchemaColumn>();
        int primaryKeyColumn = 0;
        int level = arrayLevel;
        JdbcType prevSqlType = JdbcType.NULL;
        String tableName = DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(collectionName, path), tableNameMap);
        if (tableMap.containsKey(tableName)) {
            columnMap.putAll((Map<String, DocumentDbSchemaColumn>)tableMap.get(tableName).getColumnMap());
            Iterator<DocumentDbMetadataColumn> valueColumnPath = VALUE_COLUMN_NAME;
            prevSqlType = columnMap.containsKey(DocumentDbTableSchemaGeneratorHelper.toName(VALUE_COLUMN_NAME, tableNameMap)) ? columnMap.get(DocumentDbTableSchemaGeneratorHelper.toName(VALUE_COLUMN_NAME, tableNameMap)).getSqlType() : JdbcType.JAVA_OBJECT;
        }
        JdbcType sqlType = prevSqlType;
        for (BsonValue element : array) {
            JdbcType currentSqlType;
            sqlType = DocumentDbTableSchemaGeneratorHelper.getPromotedSqlType(element.getBsonType(), sqlType);
            if (!LOGGER.isDebugEnabled() || prevSqlType.equals((Object)(currentSqlType = DocumentDbTableSchemaGeneratorHelper.getPromotedSqlType(element.getBsonType(), JdbcType.NULL)))) continue;
            LOGGER.debug(String.format("Type conflict in array table %s, types %s and %s mapped to %s.", new Object[]{tableName, prevSqlType.name(), currentSqlType, sqlType.name()}));
        }
        if (!DocumentDbTableSchemaGeneratorHelper.isComplexType(sqlType)) {
            if (DocumentDbTableSchemaGeneratorHelper.isComplexType(prevSqlType)) {
                DocumentDbTableSchemaGeneratorHelper.handleComplexScalarConflict(tableMap, tableName, columnMap);
            } else {
                sqlType = DocumentDbTableSchemaGeneratorHelper.handleArrayLevelConflict(columnMap, level, sqlType);
            }
        } else if (DocumentDbTableSchemaGeneratorHelper.isComplexType(sqlType) && !DocumentDbTableSchemaGeneratorHelper.isComplexType(prevSqlType)) {
            DocumentDbTableSchemaGeneratorHelper.handleComplexScalarConflict(tableMap, tableName, columnMap);
        }
        if (!tableMap.containsKey(tableName)) {
            for (DocumentDbMetadataColumn column : foreignKeys) {
                DocumentDbMetadataColumn metadataColumn = DocumentDbMetadataColumn.builder().fieldPath(column.getFieldPath()).sqlName(column.getSqlName()).sqlType(column.getSqlType()).dbType(column.getDbType()).isIndex(column.isIndex()).isPrimaryKey(++primaryKeyColumn != 0).foreignKeyTableName(column.getTableName().equals(tableName) ? null : column.getTableName()).index(column.getIndex()).tableName(tableName).primaryKeyIndex(primaryKeyColumn).foreignKeyIndex(column.getTableName().equals(tableName) ? 0 : primaryKeyColumn).virtualTableName(column.getVirtualTableName()).arrayIndexLevel(column.getArrayIndexLevel()).isGenerated(column.isGenerated()).build();
                metadataColumn.setForeignKeyColumnName(metadataColumn.getForeignKeyTableName() != null ? column.getSqlName() : null);
                columnMap.put(metadataColumn.getSqlName(), metadataColumn);
            }
        }
        Map<String, String> columnNameMap = columnMap.values().stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, DocumentDbSchemaColumn::getSqlName));
        String indexColumnName = DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(path, INDEX_COLUMN_NAME_PREFIX + level), columnNameMap);
        if (!columnMap.containsKey(indexColumnName)) {
            indexColumn = DocumentDbMetadataColumn.builder().sqlName(indexColumnName).fieldPath(path).sqlType(JdbcType.BIGINT).isIndex(true).isPrimaryKey(true).index(columnMap.size() + 1).tableName(tableName).primaryKeyIndex(++primaryKeyColumn).foreignKeyIndex(0).arrayIndexLevel(level).isGenerated(true).build();
            columnMap.put(indexColumn.getSqlName(), indexColumn);
        } else {
            indexColumn = (DocumentDbMetadataColumn)columnMap.get(indexColumnName);
        }
        foreignKeys.add(indexColumn);
        switch (sqlType) {
            case JAVA_OBJECT: {
                DocumentDbTableSchemaGenerator.processDocumentsInArray(array, tableMap, foreignKeys, path, collectionName, tableNameMap);
                break;
            }
            case ARRAY: {
                DocumentDbTableSchemaGenerator.processArrayInArray(array, tableMap, foreignKeys, path, collectionName, ++level, tableNameMap);
                break;
            }
            default: {
                DocumentDbTableSchemaGenerator.processValuesInArray(tableMap, path, collectionName, columnMap, sqlType, tableNameMap);
            }
        }
    }

    private static void processValuesInArray(Map<String, DocumentDbSchemaTable> tableMap, String path, String collectionName, LinkedHashMap<String, DocumentDbSchemaColumn> columnMap, JdbcType sqlType, Map<String, String> tableNameMap) {
        String tableName = DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(collectionName, path), tableNameMap);
        Map<String, String> columnNameMap = columnMap.values().stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, DocumentDbSchemaColumn::getSqlName));
        String valueColumnName = DocumentDbTableSchemaGeneratorHelper.toName(VALUE_COLUMN_NAME, columnNameMap);
        DocumentDbMetadataColumn prevMetadataColumn = (DocumentDbMetadataColumn)columnMap.get(valueColumnName);
        DocumentDbMetadataColumn metadataColumn = DocumentDbMetadataColumn.builder().fieldPath(path).sqlName(valueColumnName).sqlType(sqlType).isIndex(false).isPrimaryKey(false).index(DocumentDbTableSchemaGeneratorHelper.getPrevIndexOrDefault(prevMetadataColumn, columnMap.size() + 1)).tableName(tableName).primaryKeyIndex(0).foreignKeyIndex(0).isGenerated(false).build();
        columnMap.put(metadataColumn.getSqlName(), metadataColumn);
        DocumentDbMetadataTable metadataTable = DocumentDbMetadataTable.builder().sqlName(tableName).collectionName(collectionName).columns(columnMap).build();
        if (LOGGER.isDebugEnabled() && !tableMap.containsKey(metadataTable.getSqlName())) {
            LOGGER.debug(String.format("Added schema for table %s.", metadataTable.getSqlName()));
        }
        tableMap.put(metadataTable.getSqlName(), metadataTable);
    }

    private static void processArrayInArray(BsonArray array, Map<String, DocumentDbSchemaTable> tableMap, List<DocumentDbMetadataColumn> foreignKeys, String path, String collectionName, int level, Map<String, String> tableNameMap) {
        for (BsonValue element : array) {
            if (element.isNull()) continue;
            DocumentDbTableSchemaGenerator.processArray(element.asArray(), tableMap, foreignKeys, path, level, collectionName, tableNameMap);
        }
    }

    private static void processDocumentsInArray(BsonArray array, Map<String, DocumentDbSchemaTable> tableMap, List<DocumentDbMetadataColumn> foreignKeys, String path, String collectionName, Map<String, String> tableNameMap) {
        for (BsonValue element : array) {
            if (element.isNull()) continue;
            DocumentDbTableSchemaGenerator.processDocument(element.asDocument(), tableMap, foreignKeys, path, collectionName, false, tableNameMap);
        }
    }

    private static void processComplexTypes(Map<String, DocumentDbSchemaTable> tableMap, List<DocumentDbMetadataColumn> foreignKeys, String collectionName, Map.Entry<String, BsonValue> entry, String fieldPath, BsonType bsonType, DocumentDbMetadataColumn prevMetadataColumn, JdbcType nextSqlType, Map<String, String> tableNameMap) {
        if (nextSqlType == JdbcType.JAVA_OBJECT && bsonType != BsonType.NULL) {
            DocumentDbTableSchemaGenerator.processDocument(entry.getValue().asDocument(), tableMap, foreignKeys, fieldPath, collectionName, false, tableNameMap);
        } else if (nextSqlType == JdbcType.ARRAY && bsonType != BsonType.NULL) {
            DocumentDbTableSchemaGenerator.processArray(entry.getValue().asArray(), tableMap, foreignKeys, fieldPath, 0, collectionName, tableNameMap);
        } else if (prevMetadataColumn != null && prevMetadataColumn.getVirtualTableName() != null && bsonType != BsonType.NULL) {
            tableMap.remove(prevMetadataColumn.getVirtualTableName());
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static void buildForeignKeysFromDocument(LinkedHashMap<String, DocumentDbSchemaColumn> columnMap, String tableName, int primaryKeyColumn, DocumentDbMetadataColumn column) {
        DocumentDbMetadataColumn metadataColumn = DocumentDbMetadataColumn.builder().fieldPath(column.getFieldPath()).sqlName(column.getSqlName()).sqlType(column.getSqlType()).dbType(column.getDbType()).isIndex(column.isIndex()).isPrimaryKey(column.isPrimaryKey()).foreignKeyTableName(column.getTableName().equals(tableName) ? null : column.getTableName()).foreignKeyColumnName(column.getTableName().equals(tableName) ? null : column.getSqlName()).index(columnMap.size() + 1).tableName(column.getTableName()).primaryKeyIndex(primaryKeyColumn).foreignKeyIndex(column.getTableName().equals(tableName) ? 0 : primaryKeyColumn).arrayIndexLevel(column.getArrayIndexLevel()).isGenerated(column.isGenerated()).build();
        columnMap.put(metadataColumn.getSqlName(), metadataColumn);
    }
}

