/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

@JsonSerialize(as=DocumentDbSchemaTable.class)
public class DocumentDbMetadataTable
extends DocumentDbSchemaTable {
    @BsonIgnore
    @JsonIgnore
    private ImmutableMap<String, DocumentDbSchemaColumn> columnsByPath;
    @BsonIgnore
    @JsonIgnore
    private final ImmutableList<DocumentDbSchemaColumn> foreignKeys;

    public DocumentDbMetadataTable(String sqlName, String collectionName, LinkedHashMap<String, DocumentDbSchemaColumn> columns, ImmutableMap<String, DocumentDbMetadataColumn> columnsByPath, ImmutableList<DocumentDbSchemaColumn> foreignKeys) {
        super(sqlName, collectionName, columns);
        this.foreignKeys = foreignKeys;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static DocumentDbMetadataTableBuilder builder() {
        return new DocumentDbMetadataTableBuilder();
    }

    public ImmutableMap<String, DocumentDbSchemaColumn> getColumnsByPath() {
        return this.columnsByPath;
    }

    public static class DocumentDbMetadataTableBuilder {
        private String sqlName;
        private String collectionName;
        private LinkedHashMap<String, DocumentDbSchemaColumn> columns;
        private ImmutableMap<String, DocumentDbMetadataColumn> columnsByPath;
        private ImmutableList<DocumentDbSchemaColumn> foreignKeys;

        DocumentDbMetadataTableBuilder() {
        }

        public DocumentDbMetadataTableBuilder sqlName(String sqlName) {
            this.sqlName = sqlName;
            return this;
        }

        public DocumentDbMetadataTableBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public DocumentDbMetadataTableBuilder columns(LinkedHashMap<String, DocumentDbSchemaColumn> columns) {
            this.columns = columns;
            return this;
        }

        public DocumentDbMetadataTableBuilder columnsByPath(ImmutableMap<String, DocumentDbMetadataColumn> columnsByPath) {
            this.columnsByPath = columnsByPath;
            return this;
        }

        public DocumentDbMetadataTableBuilder foreignKeys(ImmutableList<DocumentDbSchemaColumn> foreignKeys) {
            this.foreignKeys = foreignKeys;
            return this;
        }

        public DocumentDbMetadataTable build() {
            return new DocumentDbMetadataTable(this.sqlName, this.collectionName, this.columns, this.columnsByPath, this.foreignKeys);
        }

        public String toString() {
            return "DocumentDbMetadataTable.DocumentDbMetadataTableBuilder(sqlName=" + this.sqlName + ", collectionName=" + this.collectionName + ", columns=" + this.columns + ", columnsByPath=" + this.columnsByPath + ", foreignKeys=" + this.foreignKeys + ")";
        }
    }
}

