/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import java.util.ArrayList;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;

public class DocumentDbFilter
extends Filter
implements DocumentDbRel {
    public static final String BOOLEAN_FLAG_FIELD = "\"placeholderField1F84EB1G3K47\"";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbFilter.class.getName());

    public DocumentDbFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.1) : null;
    }

    public DocumentDbFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new DocumentDbFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        DocumentDbRel.Implementor mongoImplementor = new DocumentDbRel.Implementor(implementor.getRexBuilder());
        mongoImplementor.visitChild(0, this.getInput());
        DocumentDbRules.RexToMongoTranslator rexToMongoTranslator = new DocumentDbRules.RexToMongoTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), DocumentDbRules.mongoFieldNames(this.getInput().getRowType(), mongoImplementor.getMetadataTable()), this.getInput().getRowType().getFieldNames(), mongoImplementor.getMetadataTable(), implementor.getCurrentTime());
        RexNode expandedCondition = RexUtil.expandSearch((RexBuilder)implementor.getRexBuilder(), null, (RexNode)this.condition);
        DocumentDbRules.Operand match = (DocumentDbRules.Operand)expandedCondition.accept((RexVisitor)rexToMongoTranslator);
        if (match.getQueryValue() != null) {
            String condition = match.isInputRef() ? "{" + match.getQueryValue() + ": true}" : match.getQueryValue();
            implementor.add(null, "{\"$match\": " + condition + "}");
        } else {
            this.addAggregateOperatorStages(implementor, match);
        }
        LOGGER.info("Created filter stages of pipeline.");
        LOGGER.debug("Pipeline stages added: {}", implementor.getList().stream().map(c -> (String)c.right).toArray());
    }

    private void addAggregateOperatorStages(DocumentDbRel.Implementor implementor, DocumentDbRules.Operand match) {
        if (implementor.isJoin() || this.getRowType().getFieldList().size() >= 50) {
            implementor.add(null, "{\"$addFields\": {\"placeholderField1F84EB1G3K47\": " + match + "}}");
        } else {
            ArrayList<String> projectItems = new ArrayList<String>();
            for (String projectItem : DocumentDbRules.mongoFieldNames(this.getRowType(), implementor.getMetadataTable())) {
                projectItems.add(DocumentDbRules.maybeQuote(projectItem) + ": 1");
            }
            projectItems.add("\"placeholderField1F84EB1G3K47\": " + match);
            implementor.add(null, "{\"$project\": " + Util.toString(projectItems, (String)"{", (String)", ", (String)"}") + "}");
        }
        implementor.add(null, "{\"$match\": {\"placeholderField1F84EB1G3K47\": {\"$eq\": true}}}");
        implementor.add(null, "{\"$project\": {\"placeholderField1F84EB1G3K47\":0}}");
    }
}

