/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.query;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.impl.LongSchemaVersion;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.tools.RelRunner;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbEnumerable;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbSchemaFactory;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbDatabaseSchemaMetadata;
import software.amazon.documentdb.jdbc.metadata.DocumentDbJdbcMetaDataConverter;
import software.amazon.documentdb.jdbc.query.DocumentDbMqlQueryContext;

public class DocumentDbQueryMappingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbQueryMappingService.class);
    private final DocumentDbPrepareContext prepareContext;
    private final CalcitePrepare prepare;
    private final BsonDocument maxRowsBSON;

    public DocumentDbQueryMappingService(DocumentDbConnectionProperties connectionProperties, DocumentDbDatabaseSchemaMetadata databaseMetadata) {
        connectionProperties.putIfAbsent("FUN", "standard,mysql");
        connectionProperties.putIfAbsent("UNQUOTEDCASING", "UNCHANGED");
        this.prepareContext = new DocumentDbPrepareContext(DocumentDbQueryMappingService.getRootSchemaFromDatabaseMetadata(connectionProperties, databaseMetadata), connectionProperties.getDatabase(), connectionProperties);
        this.prepare = new DocumentDbPrepareImplementation();
        this.maxRowsBSON = new BsonDocument();
    }

    public DocumentDbMqlQueryContext get(String sql, long maxRowCount) throws SQLException {
        CalcitePrepare.Query query = CalcitePrepare.Query.of((String)sql);
        try {
            CalcitePrepare.CalciteSignature signature = this.prepare.prepareSql((CalcitePrepare.Context)this.prepareContext, query, Object[].class, -1L);
            Enumerable enumerable = signature.enumerable(this.prepareContext.getDataContext());
            if (enumerable instanceof DocumentDbEnumerable) {
                DocumentDbEnumerable documentDbEnumerable = (DocumentDbEnumerable)enumerable;
                if (maxRowCount > 0L) {
                    this.maxRowsBSON.put("$limit", (BsonValue)new BsonInt64(maxRowCount));
                    documentDbEnumerable.getList().add((Bson)this.maxRowsBSON);
                }
                return DocumentDbMqlQueryContext.builder().columnMetaData(DocumentDbJdbcMetaDataConverter.fromCalciteColumnMetaData(signature.columns)).aggregateOperations(documentDbEnumerable.getList()).collectionName(documentDbEnumerable.getCollectionName()).paths(documentDbEnumerable.getPaths()).build();
            }
        }
        catch (Exception e) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_QUERY_EXPRESSION, e, SqlError.SQL_PARSE_ERROR, sql, this.getExceptionMessages(e));
        }
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_SQL, sql);
    }

    public DocumentDbMqlQueryContext get(String sql) throws SQLException {
        return this.get(sql, 0L);
    }

    private String getExceptionMessages(Throwable e) {
        StringBuilder builder = new StringBuilder(e.getMessage());
        if (e.getSuppressed() != null) {
            for (Throwable suppressed : e.getSuppressed()) {
                builder.append(" Additional info: '").append(this.getExceptionMessages(suppressed)).append("'");
            }
        }
        return builder.toString();
    }

    private static CalciteSchema getRootSchemaFromDatabaseMetadata(DocumentDbConnectionProperties connectionProperties, DocumentDbDatabaseSchemaMetadata databaseMetadata) {
        SchemaPlus parentSchema = CalciteSchema.createRootSchema((boolean)true).plus();
        Schema schema = DocumentDbSchemaFactory.create(databaseMetadata, connectionProperties);
        parentSchema.add(connectionProperties.getDatabase(), schema);
        return CalciteSchema.from((SchemaPlus)parentSchema);
    }

    private static <E extends Enum<E>> @NonNull E getSymbolValue(SqlLiteral literal, Class<E> clazz) throws SQLException {
        Enum result = literal.symbolValue(clazz);
        if (result == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_QUERY_EXPRESSION, SqlError.MISSING_LITERAL_VALUE, literal.getTypeName().getName());
        }
        return (E)result;
    }

    private static class DocumentDbPrepareContext
    implements CalcitePrepare.Context {
        private final CalciteSchema rootSchema;
        private final CalciteSchema mutableRootSchema;
        private final JavaTypeFactory typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new DocumentDbTypeSystem());
        private final CalciteConnectionConfig config;
        private final List<String> defaultSchemaPath;
        private final DataContext dataContext;

        DocumentDbPrepareContext(final CalciteSchema rootSchema, String defaultSchema, DocumentDbConnectionProperties properties) {
            this.config = new CalciteConnectionConfigImpl((Properties)properties);
            long now = System.currentTimeMillis();
            LongSchemaVersion schemaVersion = new LongSchemaVersion(now);
            this.mutableRootSchema = rootSchema;
            this.rootSchema = this.mutableRootSchema.createSnapshot((SchemaVersion)schemaVersion);
            this.defaultSchemaPath = ImmutableList.of((Object)defaultSchema);
            this.dataContext = new DataContext(){

                public SchemaPlus getRootSchema() {
                    return rootSchema.plus();
                }

                public JavaTypeFactory getTypeFactory() {
                    return typeFactory;
                }

                public QueryProvider getQueryProvider() {
                    return null;
                }

                public Object get(String name) {
                    return null;
                }
            };
        }

        public JavaTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        public CalciteSchema getRootSchema() {
            return this.rootSchema;
        }

        public CalciteSchema getMutableRootSchema() {
            return this.mutableRootSchema;
        }

        public List<String> getDefaultSchemaPath() {
            return this.defaultSchemaPath;
        }

        public CalciteConnectionConfig config() {
            return this.config;
        }

        public CalcitePrepare.SparkHandler spark() {
            boolean enable = this.config().spark();
            return CalcitePrepare.Dummy.getSparkHandler((boolean)enable);
        }

        public DataContext getDataContext() {
            return this.dataContext;
        }

        public List<String> getObjectPath() {
            return null;
        }

        public RelRunner getRelRunner() {
            return null;
        }
    }

    private static final class DocumentDbConvertletTable
    implements SqlRexConvertletTable {
        public static final DocumentDbConvertletTable INSTANCE = new DocumentDbConvertletTable();
        private final Map<SqlOperator, SqlRexConvertlet> customCovertlets = new HashMap<SqlOperator, SqlRexConvertlet>();

        private DocumentDbConvertletTable() {
            this.customCovertlets.put((SqlOperator)SqlStdOperatorTable.TIMESTAMP_DIFF, new DocumentDbTimestampDiffConvertlet());
        }

        public SqlRexConvertlet get(SqlCall call) {
            SqlOperator op = call.getOperator();
            SqlRexConvertlet convertlet = this.customCovertlets.get(op);
            if (convertlet != null) {
                return convertlet;
            }
            return StandardConvertletTable.INSTANCE.get(call);
        }

        private static class DocumentDbTimestampDiffConvertlet
        implements SqlRexConvertlet {
            private DocumentDbTimestampDiffConvertlet() {
            }

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                BigDecimal divider;
                BigDecimal multiplier;
                RexBuilder rexBuilder = cx.getRexBuilder();
                SqlLiteral unitLiteral = (SqlLiteral)call.operand(0);
                TimeUnit unit = (TimeUnit)DocumentDbQueryMappingService.getSymbolValue(unitLiteral, TimeUnit.class);
                SqlTypeName sqlTypeName = unit == TimeUnit.NANOSECOND ? SqlTypeName.BIGINT : SqlTypeName.INTEGER;
                switch (unit) {
                    case MICROSECOND: 
                    case MILLISECOND: 
                    case NANOSECOND: 
                    case WEEK: {
                        multiplier = BigDecimal.valueOf(1000L);
                        divider = unit.multiplier;
                        unit = TimeUnit.SECOND;
                        break;
                    }
                    default: {
                        multiplier = BigDecimal.ONE;
                        divider = BigDecimal.ONE;
                    }
                }
                SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
                RexNode op2 = cx.convertExpression(call.operand(2));
                RexNode op1 = cx.convertExpression(call.operand(1));
                RelDataType intervalType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlIntervalType(qualifier), op1.getType().isNullable() || op2.getType().isNullable());
                RexCall rexCall = (RexCall)rexBuilder.makeCall(intervalType, (SqlOperator)SqlStdOperatorTable.MINUS_DATE, (List)ImmutableList.of((Object)op2, (Object)op1));
                RelDataType intType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlType(sqlTypeName), SqlTypeUtil.containsNullable((RelDataType)rexCall.getType()));
                if (unit == TimeUnit.YEAR || unit == TimeUnit.QUARTER || unit == TimeUnit.MONTH) {
                    return rexBuilder.makeReinterpretCast(intType, (RexNode)rexCall, (RexNode)rexBuilder.makeLiteral(false));
                }
                RexNode e = rexBuilder.makeCast(intType, (RexNode)rexCall);
                return rexBuilder.multiplyDivide(e, multiplier, divider);
            }
        }
    }

    private static class DocumentDbPrepareImplementation
    extends CalcitePrepareImpl
    implements CalcitePrepare {
        private DocumentDbPrepareImplementation() {
        }

        protected SqlRexConvertletTable createConvertletTable() {
            return DocumentDbConvertletTable.INSTANCE;
        }
    }

    private static class DocumentDbTypeSystem
    extends RelDataTypeSystemImpl
    implements RelDataTypeSystem {
        private DocumentDbTypeSystem() {
        }

        public boolean shouldConvertRaggedUnionTypesToVarying() {
            return true;
        }
    }
}

