/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.ThreadPoolExecutor;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ThreadPoolInterceptor
implements Installable {
    private static Logger log = LogManager.getLogger(ThreadPoolInterceptor.class);

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).type(ThreadPoolInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit(Advice.to(BeforeExecuteAdvice.class).on(ThreadPoolInterceptor.createBeforeExecuteMethodMatcher())).visit(Advice.to(AfterExecuteAdvice.class).on(ThreadPoolInterceptor.createAfterExecuteMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.isSubTypeOf(ThreadPoolExecutor.class);
    }

    static ElementMatcher.Junction<? super MethodDescription> createBeforeExecuteMethodMatcher() {
        return ElementMatchers.named("beforeExecute").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    static ElementMatcher.Junction<? super MethodDescription> createAfterExecuteMethodMatcher() {
        return ElementMatchers.named("afterExecute").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    public static Runnable unDecorate(Runnable r) {
        if (r instanceof DecoratedRunnable) {
            return ((DecoratedRunnable)r).getTarget();
        }
        return r;
    }

    public static class AfterExecuteAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Runnable r) {
            r = ThreadPoolInterceptor.unDecorate(r);
        }
    }

    public static class BeforeExecuteAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=1, readOnly=false) Runnable r) {
            r = ThreadPoolInterceptor.unDecorate(r);
        }
    }
}

