/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.modifier.Visibility;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.FieldAccessor;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinTaskInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ForkJoinTaskInterceptor.class);

    ForkJoinTaskInterceptor() {
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ForkJoinTaskInterceptor.createForkJoinTaskTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.implement(new Type[]{DecoratedForkJoinTask.Accessor.class}).defineField("$discoDecoration", (Type)((Object)DecoratedForkJoinTask.class), 4).defineMethod("getDiscoDecoration", (Type)((Object)DecoratedForkJoinTask.class), Visibility.PUBLIC).intercept(FieldAccessor.ofField("$discoDecoration")).defineMethod("setDiscoDecoration", Void.TYPE, Visibility.PUBLIC).withParameter((Type)((Object)DecoratedForkJoinTask.class)).intercept(FieldAccessor.ofField("$discoDecoration")).method(ForkJoinTaskInterceptor.createForkMethodMatcher()).intercept(Advice.to(ForkAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createForkJoinTaskTypeMatcher() {
        return ElementMatchers.named("java.util.concurrent.ForkJoinTask");
    }

    static ElementMatcher.Junction<? super MethodDescription> createForkMethodMatcher() {
        return ElementMatchers.named("fork").and(ElementMatchers.takesArguments(0));
    }

    public static class ForkAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            ForkAdvice.methodEnter(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedForkJoinTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ForkJoinTask", e);
            }
        }
    }
}

