/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.assign;

import software.amazon.disco.agent.jar.asm.MethodVisitor;
import software.amazon.disco.agent.jar.bytebuddy.build.HashCodeAndEqualsPlugin;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.Implementation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.StackManipulation;

@HashCodeAndEqualsPlugin.Enhance
public class InstanceCheck
implements StackManipulation {
    private final TypeDescription typeDescription;

    protected InstanceCheck(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation of(TypeDescription typeDescription) {
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Cannot check an instance against a primitive type: " + typeDescription);
        }
        return new InstanceCheck(typeDescription);
    }

    public boolean isValid() {
        return true;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(193, this.typeDescription.getInternalName());
        return new StackManipulation.Size(0, 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((InstanceCheck)object).typeDescription);
    }

    public int hashCode() {
        return 17 * 31 + this.typeDescription.hashCode();
    }
}

