/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.plugin;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.Listener;
import software.amazon.disco.agent.inject.Injector;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.Package;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.plugin.PluginOutcome;

public class PluginDiscovery {
    private static final Logger log = LogManager.getLogger(PluginDiscovery.class);
    private static List<ClassInfo> installableClasses;
    private static List<ClassInfo> initClasses;
    private static List<ClassInfo> listenerClasses;
    private static Map<String, PluginOutcome> pluginOutcomes;

    public static void scan(Instrumentation instrumentation, AgentConfig config) {
        installableClasses = new LinkedList<ClassInfo>();
        initClasses = new LinkedList<ClassInfo>();
        listenerClasses = new LinkedList<ClassInfo>();
        pluginOutcomes = new HashMap<String, PluginOutcome>();
        try {
            if (config.getPluginPath() == null) {
                log.info("DiSCo(Core) no plugin path specified, skipping plugin scan");
                return;
            }
            File pluginDir = new File(config.getPluginPath());
            if (!pluginDir.isDirectory()) {
                log.warn("DiSCo(Core) invalid plugin path specified, skipping plugin scan");
                return;
            }
            File[] files = pluginDir.listFiles();
            if (files != null) {
                for (File jarFile : files) {
                    if (jarFile.getName().substring(jarFile.getName().lastIndexOf(".")).equalsIgnoreCase(".jar")) {
                        PluginDiscovery.processJarFile(instrumentation, jarFile, config.isRuntimeOnly());
                        continue;
                    }
                    log.info("DiSCo(Core) non JAR file found on plugin path, skipping this file");
                }
            }
        }
        catch (Throwable t) {
            log.error("DiSCo(Core) error while processing plugins", t);
        }
    }

    public static Set<Installable> processInstallables() {
        HashSet<Installable> installables = new HashSet<Installable>();
        if (installableClasses != null && !installableClasses.isEmpty()) {
            for (ClassInfo info : installableClasses) {
                if (Installable.class.isAssignableFrom(info.clazz)) {
                    try {
                        Installable installable = (Installable)info.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        installables.add(installable);
                        PluginDiscovery.pluginOutcomes.get((Object)info.pluginName).installables.add(installable);
                    }
                    catch (Exception e) {
                        log.warn("DiSCo(Core) could not instantiate Installable " + info.clazz.getName(), e);
                    }
                    continue;
                }
                if (!Package.class.isAssignableFrom(info.clazz)) continue;
                try {
                    Package pkg = (Package)info.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Collection<Installable> pkgInstallables = pkg.get();
                    installables.addAll(pkgInstallables);
                    PluginDiscovery.pluginOutcomes.get((Object)info.pluginName).installables.addAll(pkgInstallables);
                }
                catch (Exception e) {
                    log.warn("DiSCo(Core) could not instantiate Package " + info.clazz.getName(), e);
                }
            }
        }
        return installables;
    }

    public static Collection<PluginOutcome> apply() {
        if (initClasses != null && !initClasses.isEmpty()) {
            for (ClassInfo info : initClasses) {
                try {
                    info.clazz.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
                    PluginDiscovery.pluginOutcomes.get((Object)info.pluginName).initClass = info.clazz;
                }
                catch (Exception e) {
                    log.warn("DiSCo(Core) could not process the init() method of " + info.clazz.getName(), e);
                }
            }
        }
        if (listenerClasses != null && !listenerClasses.isEmpty()) {
            for (ClassInfo info : listenerClasses) {
                try {
                    Listener listener = (Listener)info.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    EventBus.addListener(listener);
                    PluginDiscovery.pluginOutcomes.get((Object)info.pluginName).listeners.add(listener);
                }
                catch (Exception e) {
                    log.warn("DiSCo(Core) could not add the Listener " + info.clazz.getName(), e);
                }
            }
        }
        return pluginOutcomes.values();
    }

    static void processJarFile(Instrumentation instrumentation, File jarFile, boolean runtimeOnly) throws Exception {
        boolean bootstrap;
        boolean isPlugin;
        JarFile jar = new JarFile(jarFile);
        Manifest manifest = jar.getManifest();
        jar.close();
        if (manifest == null) {
            log.info("DiSCo(Core) JAR file without manifest found on plugin path, skipping this file");
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null || attributes.isEmpty()) {
            log.info("DiSCo(Core) JAR file found with manifest without any main attributes, skipping this file");
            return;
        }
        String initClassName = attributes.getValue("Disco-Init-Class");
        String installableClassNames = attributes.getValue("Disco-Installable-Classes");
        String listenerClassNames = attributes.getValue("Disco-Listener-Classes");
        String bootstrapClassloader = attributes.getValue("Disco-Bootstrap-Classloader");
        boolean bl = isPlugin = initClassName != null || installableClassNames != null || listenerClassNames != null || bootstrapClassloader != null;
        if (!isPlugin) {
            log.info("DiSCo(Core) JAR file manifest contains no Disco attributes, skipping this file");
            return;
        }
        String pluginName = jarFile.getName();
        pluginOutcomes.put(pluginName, new PluginOutcome(pluginName));
        PluginDiscovery.pluginOutcomes.get((Object)pluginName).bootstrap = bootstrap = PluginDiscovery.loadJar(instrumentation, jarFile, bootstrapClassloader);
        PluginDiscovery.processInitClass(pluginName, initClassName, bootstrap);
        PluginDiscovery.processInstallableClasses(pluginName, installableClassNames, bootstrap, runtimeOnly);
        PluginDiscovery.processListenerClasses(pluginName, listenerClassNames, bootstrap);
    }

    static boolean loadJar(Instrumentation instrumentation, File jarFile, String bootstrapClassLoader) throws Exception {
        boolean bootstrap = false;
        if (bootstrapClassLoader != null && bootstrapClassLoader.trim().equalsIgnoreCase("true")) {
            bootstrap = true;
        }
        JarFile jar = null;
        if (bootstrap) {
            if (LogManager.isDebugEnabled()) {
                log.debug("DiSCo(Core) attempting to load JAR file into bootstrap classloader: " + jarFile.getName());
            }
            jar = Injector.addToBootstrapClasspath(instrumentation, jarFile);
        } else {
            if (LogManager.isDebugEnabled()) {
                log.debug("DiSCo(Core) attempting to load JAR file into system classloader: " + jarFile.getName());
            }
            jar = Injector.addToSystemClasspath(instrumentation, jarFile);
        }
        if (jar != null) {
            jar.close();
        }
        return bootstrap;
    }

    static void processInitClass(String pluginName, String initClassName, boolean bootstrap) throws Exception {
        if (initClassName != null) {
            Class<?> clazz = PluginDiscovery.classForName(initClassName.trim(), bootstrap);
            ClassInfo initInfo = new ClassInfo(pluginName, clazz, bootstrap);
            initClasses.add(initInfo);
        }
    }

    static void processInstallableClasses(String pluginName, String installableClassNames, boolean bootstrap, boolean runtimeOnly) throws Exception {
        if (installableClassNames != null) {
            String[] classNames;
            for (String className : classNames = PluginDiscovery.splitString(installableClassNames)) {
                if (runtimeOnly) {
                    log.info("DiSCo(Core) Installable/Package declared in plugin will be ignored because agent is configured as runtime only: " + className);
                    continue;
                }
                try {
                    Class<?> clazz = PluginDiscovery.classForName(className.trim(), bootstrap);
                    if (Installable.class.isAssignableFrom(clazz) || Package.class.isAssignableFrom(clazz)) {
                        ClassInfo installableInfo = new ClassInfo(pluginName, clazz, bootstrap);
                        installableClasses.add(installableInfo);
                        continue;
                    }
                    log.warn("DiSCo(Core) specified Installable is not an instance of Installable or Package: " + className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("DiSCo(Core) cannot locate Installable: " + className, e);
                }
            }
        }
    }

    static void processListenerClasses(String pluginName, String listenerClassNames, boolean bootstrap) throws Exception {
        if (listenerClassNames != null) {
            String[] classNames;
            for (String className : classNames = PluginDiscovery.splitString(listenerClassNames)) {
                if (LogManager.isDebugEnabled()) {
                    log.debug("DiSCo(Core) attempting to add Listener from plugin using class: " + className);
                }
                try {
                    Class<?> clazz = PluginDiscovery.classForName(className.trim(), bootstrap);
                    if (Listener.class.isAssignableFrom(clazz)) {
                        ClassInfo installableInfo = new ClassInfo(pluginName, clazz, bootstrap);
                        listenerClasses.add(installableInfo);
                        continue;
                    }
                    log.warn("DiSCo(Core) specified Listener is not an instance of Listener: " + className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("DiSCo(Core) failed to instantiate Listener: " + className, e);
                }
            }
        }
    }

    static Class<?> classForName(String name, boolean bootstrap) throws Exception {
        return bootstrap ? Class.forName(name, false, null) : Class.forName(name, false, ClassLoader.getSystemClassLoader());
    }

    static String[] splitString(String input) {
        return input.trim().split("\\s+");
    }

    static class ClassInfo {
        final String pluginName;
        final Class<?> clazz;
        final boolean bootstrap;

        ClassInfo(String pluginName, Class<?> clazz, boolean bootstrap) {
            this.pluginName = pluginName;
            this.clazz = clazz;
            this.bootstrap = bootstrap;
        }
    }
}

