/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import java.util.Map;
import software.amazon.disco.agent.event.AbstractNetworkProtocolRequestEvent;
import software.amazon.disco.agent.event.HttpNetworkProtocolRequestEvent;
import software.amazon.disco.agent.event.NetworkProtocolEvent;

public class HttpServletNetworkRequestEvent
extends AbstractNetworkProtocolRequestEvent
implements HttpNetworkProtocolRequestEvent {
    private String method;
    private String httpURL;
    private static final String DATE_HEADER = "date";
    private static final String HOST_HEADER = "host";
    private static final String ORIGIN_HEADER = "origin";
    private static final String REFERER_HEADER = "referer";
    private static final String USER_AGENT_HEADER = "user-agent";

    public HttpServletNetworkRequestEvent(String origin, int srcPort, int dstPort, String srcIP, String dstIP) {
        super(origin, srcPort, dstPort, srcIP, dstIP);
    }

    private HttpServletNetworkRequestEvent withHeaderInput(String key, String data) {
        super.withHeaderData(key, data);
        return this;
    }

    public HttpServletNetworkRequestEvent withDate(String date) {
        return this.withHeaderInput(DATE_HEADER, date);
    }

    public HttpServletNetworkRequestEvent withHost(String host) {
        return this.withHeaderInput(HOST_HEADER, host);
    }

    public HttpServletNetworkRequestEvent withHTTPOrigin(String origin) {
        return this.withHeaderInput(ORIGIN_HEADER, origin);
    }

    public HttpServletNetworkRequestEvent withReferer(String referer) {
        return this.withHeaderInput(REFERER_HEADER, referer);
    }

    public HttpServletNetworkRequestEvent withUserAgent(String userAgent) {
        return this.withHeaderInput(USER_AGENT_HEADER, userAgent);
    }

    @Override
    public HttpServletNetworkRequestEvent withHeaderMap(Map<String, String> inputMap) {
        super.withHeaderMap(inputMap);
        return this;
    }

    public HttpServletNetworkRequestEvent withMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpServletNetworkRequestEvent withURL(String url) {
        this.httpURL = url;
        return this;
    }

    @Override
    public HttpServletNetworkRequestEvent withRequest(Object request) {
        super.withRequest(request);
        return this;
    }

    @Override
    public String getHeaderData(String key) {
        return super.getHeaderData(key);
    }

    @Override
    public String getDate() {
        return this.getHeaderData(DATE_HEADER);
    }

    @Override
    public String getHost() {
        return this.getHeaderData(HOST_HEADER);
    }

    @Override
    public String getHTTPOrigin() {
        return this.getHeaderData(ORIGIN_HEADER);
    }

    @Override
    public String getReferer() {
        return this.getHeaderData(REFERER_HEADER);
    }

    @Override
    public String getUserAgent() {
        return this.getHeaderData(USER_AGENT_HEADER);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getURL() {
        return this.httpURL;
    }

    @Override
    public String getRemoteIPAddress() {
        return super.getSourceIP();
    }

    @Override
    public String getLocalIPAddress() {
        return super.getDestinationIP();
    }

    @Override
    public NetworkProtocolEvent.NetworkType getNetworkType() {
        return NetworkProtocolEvent.NetworkType.TCP;
    }
}

