/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;

public class PreprocessorArgumentsExporter {
    public List<String> exportArguments(List<String[]> preprocessorRawCommandlineArgsList, PreprocessConfig config, String relativeOutputPath) {
        ArrayList<String> argsFilePaths = new ArrayList<String>();
        File preprocessorArgsTempFolder = Paths.get(config.getOutputDir(), relativeOutputPath).toFile();
        this.setUp(preprocessorArgsTempFolder);
        for (int i = 0; i < preprocessorRawCommandlineArgsList.size(); ++i) {
            String fileName = "worker-" + i + "-" + new Date().getTime() + ".txt";
            String preprocessorArgsFilePath = this.saveArgsFileToDisk(preprocessorRawCommandlineArgsList.get(i), preprocessorArgsTempFolder.getAbsolutePath(), fileName);
            argsFilePaths.add("@" + preprocessorArgsFilePath);
        }
        return argsFilePaths;
    }

    protected void setUp(File preprocessorArgsTempFolder) {
        if (preprocessorArgsTempFolder.exists()) {
            for (File subFile : preprocessorArgsTempFolder.listFiles()) {
                subFile.delete();
            }
        } else if (!preprocessorArgsTempFolder.mkdirs()) {
            throw new ExportException("Failed to create folder to store command-line arguments files.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String saveArgsFileToDisk(String[] commandlineArguments, String outputPath, String relativePath) {
        File destinationFile = Paths.get(outputPath, relativePath).toFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));){
            destinationFile.createNewFile();
            writer.write(String.join((CharSequence)" ", commandlineArguments));
            writer.close();
            String string = destinationFile.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            throw new ExportException("Failed to write command-line arguments to: " + destinationFile.getName(), e);
        }
    }
}

