/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.export;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Map;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class DirectoryExportStrategy
extends ExportStrategy {
    private static final Logger log = LogManager.getLogger(DirectoryExportStrategy.class);

    @Override
    public File export(SourceInfo info, Map<String, InstrumentationArtifact> artifacts, PreprocessConfig config, String relativePath) {
        if (artifacts == null || artifacts.isEmpty()) {
            log.debug("Disco(Instrumentation preprocess) - Nothing to export, skipping");
            return null;
        }
        log.debug("Disco(Instrumentation preprocess) - Exporting " + artifacts.size() + " artifacts from source: " + info.getSourceFile().getPath());
        File parentDir = Paths.get(config.getOutputDir(), relativePath).toFile();
        parentDir.mkdirs();
        for (Map.Entry<String, InstrumentationArtifact> entry : artifacts.entrySet()) {
            this.saveArtifactToDisk(entry, config, relativePath);
        }
        log.debug("Disco(Instrumentation preprocess) - Exporting completed");
        return parentDir;
    }

    protected void saveArtifactToDisk(Map.Entry<String, InstrumentationArtifact> entry, PreprocessConfig config, String relativePath) {
        File destinationFile = this.createOutputFile(config.getOutputDir(), relativePath, entry.getKey() + ".class");
        log.trace("Disco(Instrumentation preprocess) - Exporting class: " + destinationFile.getName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            fileOutputStream.write(entry.getValue().getClassBytes());
        }
        catch (Throwable t) {
            throw new ExportException("Failed to export class: " + destinationFile.getName(), t);
        }
    }
}

