/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.InterceptionListener;
import software.amazon.disco.agent.interception.OneShotInstallable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.ResettableClassFileTransformer;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.matchers.TrieNameMatcher;

public class InterceptionInstaller {
    private static final InterceptionInstaller INSTANCE = new InterceptionInstaller(new DefaultAgentBuilderFactory());
    private static final Logger log = LogManager.getLogger(InterceptionInstaller.class);
    private final Supplier<AgentBuilder> agentBuilderFactory;
    private static final String[] IGNORE_PREFIXES = new String[]{"sun.", "com.sun.", "java.lang.ClassLoader$", "jdk.", "org.jacoco.", "org.junit.", "org.aspectj.", "software.amazon.disco.agent."};
    private static final ElementMatcher.Junction<? super TypeDescription> TRIE_BASED_IGNORE_MATCHER_INSTANCE = new TrieNameMatcher<TypeDescription>(IGNORE_PREFIXES);

    InterceptionInstaller(Supplier<AgentBuilder> agentBuilderFactory) {
        this.agentBuilderFactory = agentBuilderFactory;
    }

    public static InterceptionInstaller getInstance() {
        return INSTANCE;
    }

    public void install(Instrumentation instrumentation, Set<Installable> installables, AgentConfig config, ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        ElementMatcher.Junction<? super TypeDescription> ignoreMatcher = InterceptionInstaller.createIgnoreMatcher(customIgnoreMatcher);
        ArrayList<ResettableClassFileTransformer> oneShotTransformers = new ArrayList<ResettableClassFileTransformer>();
        ArrayList<OneShotInstallable> oneShotInstallables = new ArrayList<OneShotInstallable>();
        for (Installable installable : installables) {
            AgentBuilder agentBuilder = this.agentBuilderFactory.get().ignore(ignoreMatcher);
            if (config.isExtraverbose()) {
                agentBuilder = agentBuilder.with(InterceptionListener.create(installable));
            }
            agentBuilder = config.getAgentBuilderTransformer().apply(agentBuilder, installable);
            log.info("DiSCo(Core) attempting to install " + installable.getClass().getName());
            if ((agentBuilder = installable.install(agentBuilder)) == null) continue;
            ResettableClassFileTransformer transformer = agentBuilder.installOn(instrumentation);
            if (!(installable instanceof OneShotInstallable)) continue;
            oneShotInstallables.add((OneShotInstallable)installable);
            oneShotTransformers.add(transformer);
        }
        for (OneShotInstallable oneShotInstallable : oneShotInstallables) {
            oneShotInstallable.beforeDisposal();
        }
        for (ClassFileTransformer classFileTransformer : oneShotTransformers) {
            instrumentation.removeTransformer(classFileTransformer);
        }
    }

    public static ElementMatcher.Junction<? super TypeDescription> createIgnoreMatcher(ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        return TRIE_BASED_IGNORE_MATCHER_INSTANCE.and(ElementMatchers.not(ElementMatchers.nameStartsWith("software.amazon.disco.agent.integtest."))).or(customIgnoreMatcher);
    }

    private static class DefaultAgentBuilderFactory
    implements Supplier<AgentBuilder> {
        private DefaultAgentBuilderFactory() {
        }

        @Override
        public AgentBuilder get() {
            return new AgentBuilder.Default();
        }
    }
}

