/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import software.amazon.disco.instrumentation.preprocess.exceptions.JarEntryCopyException;

public class JarFileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readEntryFromJar(JarFile jarfile, JarEntry entry) {
        try (InputStream entryStream = jarfile.getInputStream(entry);){
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int len = entryStream.read(buffer);
            while (len != -1) {
                os.write(buffer, 0, len);
                len = entryStream.read(buffer);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new JarEntryCopyException(entry.getName(), e);
        }
    }
}

