/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.util.HashMap;
import java.util.Map;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.dynamic.DynamicType;
import software.amazon.disco.agent.jar.bytebuddy.utility.JavaModule;
import software.amazon.disco.instrumentation.preprocess.exceptions.InstrumentationException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;

public class TransformationListener
implements AgentBuilder.Listener {
    private static final Map<String, InstrumentationArtifact> instrumentedTypes = new HashMap<String, InstrumentationArtifact>();
    private final String uid;

    public TransformationListener(String uid) {
        this.uid = uid;
    }

    public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
    }

    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
        this.collectDataFromEvent(typeDescription, dynamicType);
    }

    public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
    }

    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        throw new InstrumentationException("Failed to instrument : " + typeName, throwable);
    }

    public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
    }

    protected void collectDataFromEvent(TypeDescription typeDescription, DynamicType dynamicType) {
        if (instrumentedTypes.containsKey(typeDescription.getInternalName())) {
            instrumentedTypes.get(typeDescription.getInternalName()).update(this.uid, dynamicType.getBytes());
        } else {
            instrumentedTypes.put(typeDescription.getInternalName(), new InstrumentationArtifact(this.uid, dynamicType.getBytes()));
        }
        if (!dynamicType.getAuxiliaryTypes().isEmpty()) {
            for (Map.Entry auxiliaryEntry : dynamicType.getAuxiliaryTypes().entrySet()) {
                instrumentedTypes.put(((TypeDescription)auxiliaryEntry.getKey()).getInternalName(), new InstrumentationArtifact(null, (byte[])auxiliaryEntry.getValue()));
            }
        }
    }

    public static Map<String, InstrumentationArtifact> getInstrumentedTypes() {
        return instrumentedTypes;
    }
}

