/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.agent.plugin.ResourcesClassInjector;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.InstrumentationException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationOutcome;
import software.amazon.disco.instrumentation.preprocess.instrumentation.TransformationListener;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.TransformerExtractor;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.ClassFileLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class InstrumentationTask {
    private static final Logger log = LogManager.getLogger(InstrumentationTask.class);
    private final ClassFileLoader loader;
    private final Path sourcePath;
    private final PreprocessConfig config;
    private final String relativeOutputPath;
    private final List<String> warnings = new ArrayList<String>();

    protected InstrumentationOutcome applyInstrumentation() {
        SourceInfo sourceInfo = this.loader.load(this.sourcePath, this.config);
        if (sourceInfo != null) {
            log.debug("Disco(Instrumentation preprocess) - Applying transformation on: " + sourceInfo.getSourceFile().getAbsolutePath());
            log.debug("Disco(Instrumentation preprocess) - Classes found: " + sourceInfo.getClassByteCodeMap().size());
            for (Map.Entry<String, byte[]> entry : sourceInfo.getClassByteCodeMap().entrySet()) {
                this.applyInstrumentationOnClass(entry.getKey(), entry.getValue());
            }
            log.debug("Disco(Instrumentation preprocess) - " + this.getInstrumentationArtifacts().size() + " classes transformed");
            sourceInfo.getExportStrategy().export(sourceInfo, this.getInstrumentationArtifacts(), this.config, this.relativeOutputPath);
        }
        InstrumentationOutcome.InstrumentationOutcomeBuilder builder = InstrumentationOutcome.builder().source(this.sourcePath.toString());
        if (!this.warnings.isEmpty()) {
            builder.status(InstrumentationOutcome.Status.WARNING_OCCURRED).failedClasses(this.warnings);
        } else {
            builder.status(this.getInstrumentationArtifacts().isEmpty() ? InstrumentationOutcome.Status.NO_OP : InstrumentationOutcome.Status.COMPLETED);
        }
        this.clearInstrumentationArtifacts();
        return builder.build();
    }

    protected void applyInstrumentationOnClass(String classFileName, byte[] bytecode) {
        try {
            String nameWithoutPrefix = classFileName.startsWith("classes.") ? classFileName.substring(8) : classFileName;
            String internalName = nameWithoutPrefix.replace('.', '/');
            for (ClassFileTransformer transformer : TransformerExtractor.getTransformers()) {
                byte[] bytecodeToTransform = this.getInstrumentationArtifacts().containsKey(internalName) ? this.getInstrumentationArtifacts().get(internalName).getClassBytes() : bytecode;
                transformer.transform(ClassLoader.getSystemClassLoader(), nameWithoutPrefix, null, null, bytecodeToTransform);
            }
        }
        catch (IllegalClassFormatException e) {
            throw new InstrumentationException("Failed to instrument : " + classFileName, e);
        }
        catch (InstrumentationException e) {
            if (e.getCause() != null && e.getCause() instanceof IllegalStateException && !this.config.isFailOnUnresolvableDependency()) {
                log.warn("Disco(Instrumentation preprocess) - Failed to resolve dependency when instrumenting : " + classFileName, (Throwable)e);
                this.warnings.add(classFileName);
            }
            throw e;
        }
    }

    protected Map<String, InstrumentationArtifact> getInstrumentationArtifacts() {
        HashMap<String, InstrumentationArtifact> mergedMap = new HashMap<String, InstrumentationArtifact>();
        mergedMap.putAll(TransformationListener.getInstrumentedTypes());
        mergedMap.putAll(ResourcesClassInjector.getInjectedDependencies().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new InstrumentationArtifact((byte[])e.getValue()))));
        return mergedMap;
    }

    protected void clearInstrumentationArtifacts() {
        TransformationListener.getInstrumentedTypes().clear();
        ResourcesClassInjector.getInjectedDependencies().clear();
    }

    public InstrumentationTask(ClassFileLoader loader, Path sourcePath, PreprocessConfig config, String relativeOutputPath) {
        this.loader = loader;
        this.sourcePath = sourcePath;
        this.config = config;
        this.relativeOutputPath = relativeOutputPath;
    }
}

