/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class JarExportStrategy
extends ExportStrategy {
    private static final Logger log = LogManager.getLogger(JarExportStrategy.class);

    @Override
    public void export(SourceInfo sourceInfo, Map<String, InstrumentationArtifact> instrumented, PreprocessConfig config, String relativeOutputPath) {
        String jarName = sourceInfo.getSourceFile().getName();
        if (!instrumented.isEmpty()) {
            log.info(String.format("Disco(Instrumentation preprocess) - Saving instrumented classes to %s.", jarName));
            File file = this.createOutputFile(config.getOutputDir(), relativeOutputPath, sourceInfo.getSourceFile().getName());
            try (JarOutputStream jarOS = new JarOutputStream(new FileOutputStream(file));
                 JarFile jarFile = new JarFile(sourceInfo.getSourceFile());){
                this.copyExistingJarEntries(jarOS, jarFile, instrumented);
                this.saveInstrumentationArtifactsToJar(jarOS, instrumented);
            }
            catch (IOException e) {
                throw new ExportException("Failed to create output Jar file", e);
            }
            log.debug(String.format("Disco(Instrumentation preprocess) - Exporting completed for %s", jarName));
        } else {
            log.debug(String.format("Disco(Instrumentation preprocess) - No classes instrumented for %s, skipping to next Jar", jarName));
        }
    }

    protected void copyExistingJarEntries(JarOutputStream jarOS, JarFile jarFile, Map<String, InstrumentationArtifact> artifacts) {
        log.info("Disco(Instrumentation preprocess) - Copying existing entries from file: " + jarFile.getName());
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String keyToCheck = entry.getName().endsWith(".class") ? entry.getName().substring(0, entry.getName().lastIndexOf(".class")) : entry.getName();
            try {
                if (artifacts.containsKey(keyToCheck)) continue;
                if (entry.isDirectory()) {
                    jarOS.putNextEntry(entry);
                    continue;
                }
                this.copyJarEntry(jarOS, jarFile, entry);
            }
            catch (IOException e) {
                throw new ExportException("Failed to copy class: " + entry.getName(), e);
            }
        }
    }
}

