/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class JDKExportStrategy
extends ExportStrategy {
    public static final String INSTRUMENTED_JDK_OUTPUT_NAME = "InstrumentedJDK.jar";
    public static final String PACKAGE_TO_INSERT = "software/amazon/disco/agent/concurrent/preprocess";
    private static final Logger log = LogManager.getLogger(JDKExportStrategy.class);

    @Override
    public void export(SourceInfo info, Map<String, InstrumentationArtifact> artifacts, PreprocessConfig config, String relativeOutputPath) {
        log.info("Disco(Instrumentation preprocess) - Attempting to export artifacts JDK classes");
        try {
            File tempFile = this.createOutputFile(config.getOutputDir(), relativeOutputPath, INSTRUMENTED_JDK_OUTPUT_NAME);
            try (JarOutputStream os = new JarOutputStream(new FileOutputStream(tempFile));){
                this.saveInstrumentationArtifactsToJar(os, artifacts);
                JarFile agentJar = new JarFile(new File(config.getAgentPath()));
                for (Map.Entry<String, JarEntry> entry : this.extractBootstrapDependenciesFromAgent(agentJar).entrySet()) {
                    this.copyJarEntry(os, agentJar, entry.getValue());
                }
            }
            log.info("Disco(Instrumentation preprocess) - Instrumented JDK moved to destination");
        }
        catch (IOException e) {
            throw new ExportException("Failed to create temp Jar file", e);
        }
        finally {
            artifacts.clear();
        }
    }

    protected Map<String, JarEntry> extractBootstrapDependenciesFromAgent(JarFile agentJar) {
        log.info("Disco(Instrumentation preprocess) - Extracting dependencies from agent");
        HashMap<String, JarEntry> result = new HashMap<String, JarEntry>();
        Enumeration<JarEntry> entries = agentJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(PACKAGE_TO_INSERT)) continue;
            result.put(entry.getName(), entry);
        }
        return result;
    }
}

