/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.export;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class DirectoryExportStrategy
extends ExportStrategy {
    private static final Logger log = LogManager.getLogger(DirectoryExportStrategy.class);

    @Override
    public void export(SourceInfo info, Map<String, InstrumentationArtifact> artifacts, PreprocessConfig config, String relativePath) {
        if (artifacts == null || artifacts.isEmpty()) {
            log.debug("Disco(Instrumentation preprocess) - Nothing to export, skipping");
        } else {
            log.debug("Disco(Instrumentation preprocess) - Exporting " + artifacts.size() + " artifacts from source: " + info.getSourceFile().getPath());
            for (Map.Entry<String, InstrumentationArtifact> entry : artifacts.entrySet()) {
                this.saveArtifactToDisk(entry, config, relativePath);
            }
            log.debug("Disco(Instrumentation preprocess) - Exporting completed");
        }
    }

    protected void saveArtifactToDisk(Map.Entry<String, InstrumentationArtifact> entry, PreprocessConfig config, String relativePath) {
        File destinationFile = this.createOutputFile(config.getOutputDir(), relativePath, entry.getKey() + ".class");
        log.trace("Disco(Instrumentation preprocess) - Exporting class: " + destinationFile.getName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            fileOutputStream.write(entry.getValue().getClassBytes());
        }
        catch (Throwable t) {
            throw new ExportException("Failed to export class: " + destinationFile.getName(), t);
        }
    }
}

