/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedScheduledFutureTask;
import software.amazon.disco.agent.interception.InstallationError;
import software.amazon.disco.agent.interception.OneShotInstallable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ScheduledFutureTaskInterceptor
implements OneShotInstallable {
    private static final String TARGET_CLASS_FQN = "java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask";
    private static final Logger log = LogManager.getLogger(ScheduledFutureTaskInterceptor.class);

    ScheduledFutureTaskInterceptor() {
    }

    static Class<?> getTargetClass() throws ReflectiveOperationException {
        return Class.forName(TARGET_CLASS_FQN);
    }

    static ElementMatcher.Junction<? super TypeDescription> createScheduledFutureTaskTypeMatcher() {
        return ElementMatchers.named((String)TARGET_CLASS_FQN);
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunMethodMatcher() {
        return ElementMatchers.named((String)"run").and((ElementMatcher)ElementMatchers.takesArguments((int)0));
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ScheduledFutureTaskInterceptor.createScheduledFutureTaskTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.implement(new Type[]{DecoratedScheduledFutureTask.Accessor.class}).defineField("$discoDecoration", DecoratedScheduledFutureTask.class, 4).defineMethod("getDiscoDecoration", DecoratedScheduledFutureTask.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).defineMethod("setDiscoDecoration", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(DecoratedScheduledFutureTask.class).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).visit((AsmVisitorWrapper)Advice.to(ConstructorAdvice.class).on((ElementMatcher)ElementMatchers.isConstructor())).visit((AsmVisitorWrapper)Advice.to(RunAdvice.class).on(ScheduledFutureTaskInterceptor.createRunMethodMatcher())));
    }

    @Override
    public void beforeDisposal() {
        Class<?> clazz = null;
        try {
            clazz = ScheduledFutureTaskInterceptor.getTargetClass();
        }
        catch (ReflectiveOperationException e) {
            log.error("DiSCo(Concurrency) failed to resolve ScheduledFutureTask class");
        }
        if (clazz != null) {
            OneShotInstallable.forceClassLoad(clazz);
        }
    }

    public List<InstallationError> verifyEffect() {
        LinkedList<InstallationError> errors = new LinkedList<InstallationError>();
        try {
            ScheduledFutureTaskInterceptor.getTargetClass().getDeclaredField("$discoDecoration");
        }
        catch (ReflectiveOperationException e) {
            errors.add(new InstallationError("DiSCo(Concurrency) failed to instrument class java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask"));
        }
        return errors;
    }

    public static class RunAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            RunAdvice.methodEnter(thiz);
        }

        @Advice.OnMethodExit
        public static void onMethodExit(@Advice.This Object thiz) {
            RunAdvice.methodExit(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.getDiscoDecoration().before();
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ScheduledFutureTask", (Throwable)e);
            }
        }

        public static void methodExit(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.getDiscoDecoration().after();
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ScheduledFutureTask", (Throwable)e);
            }
        }
    }

    public static class ConstructorAdvice {
        @Advice.OnMethodExit
        public static void onMethodExit(@Advice.This Object thiz) {
            ConstructorAdvice.methodExit(thiz);
        }

        public static void methodExit(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedScheduledFutureTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to capture context in ScheduledFutureTask", (Throwable)e);
            }
        }
    }
}

