/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class MethodInterceptionCounter {
    private static final Logger log = LogManager.getLogger(MethodInterceptionCounter.class);
    final ThreadLocal<AtomicInteger> localReferenceCounter = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public int increment() {
        return this.localReferenceCounter.get().incrementAndGet();
    }

    public int decrement() {
        int ret = this.localReferenceCounter.get().decrementAndGet();
        if (ret < 0) {
            if (LogManager.isDebugEnabled()) {
                log.debug("Disco(Core) method interception counter dropped below zero, indicating increment/decrement mismatch", (Throwable)new RuntimeException());
            }
            this.localReferenceCounter.get().set(0);
        }
        return ret;
    }

    public boolean hasIntercepted() {
        return this.localReferenceCounter.get().get() > 0;
    }
}

