/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.utility.JavaModule;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class InterceptionListener
implements AgentBuilder.Listener {
    private static Logger log = LogManager.getLogger(InterceptionListener.class);
    private final String prefix;
    private final boolean shouldTrace = LogManager.isTraceEnabled();

    private InterceptionListener(Installable installable) {
        this.prefix = installable.getClass().getName();
    }

    static InterceptionListener create(Installable installable) {
        return new InterceptionListener(installable);
    }

    public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " discovered " + typeName + (loaded ? " (after" : " (before") + " loading)");
        }
    }

    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
        log.debug("DiSCo(Core) " + this.prefix + " transforming " + typeDescription.getName() + (loaded ? " (after" : " (before") + " loading)");
    }

    public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " ignoring " + typeDescription.getName() + (loaded ? " (after" : " (before") + " loading)");
        }
    }

    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        log.warn("DiSCo(Core) " + this.prefix + " failed to transform " + typeName + (loaded ? " (after" : " (before") + " loading) in classloader " + classLoader.toString(), throwable);
    }

    public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " completed " + typeName + (loaded ? "(after" : "(before") + " loading)");
        }
    }
}

