/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent.decorate;

import java.util.concurrent.ConcurrentMap;
import software.amazon.disco.agent.concurrent.ConcurrentUtils;
import software.amazon.disco.agent.concurrent.MetadataItem;
import software.amazon.disco.agent.concurrent.TransactionContext;

public abstract class Decorated {
    private boolean removeTransactionContext = false;
    protected Long ancestralThreadId;
    protected long parentThreadId;
    ConcurrentMap<String, MetadataItem> parentTransactionContext = TransactionContext.getPrivateMetadata();

    protected Decorated() {
        MetadataItem data = (MetadataItem)this.parentTransactionContext.get("$amazon.discoTransactionOwningThreadId");
        this.ancestralThreadId = (Long)data.get();
        this.parentThreadId = Thread.currentThread().getId();
    }

    public void removeTransactionContext(boolean removeTransactionContext) {
        this.removeTransactionContext = removeTransactionContext;
    }

    public void before() {
        ConcurrentUtils.enter(this.ancestralThreadId, this.parentThreadId, this.parentTransactionContext);
    }

    public void after() {
        ConcurrentUtils.exit(this.ancestralThreadId, this.parentThreadId, this.parentTransactionContext, this.removeTransactionContext);
    }
}

