/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedThread;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ThreadSubclassInterceptor
implements Installable {
    public static final String DISCO_DECORATION_FIELD_NAME = "discoDecoration";
    public static Logger log = LogManager.getLogger(ThreadSubclassInterceptor.class);

    ThreadSubclassInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ThreadSubclassInterceptor.createThreadSubclassTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.defineField(DISCO_DECORATION_FIELD_NAME, DecoratedThread.class, 4).method(ThreadSubclassInterceptor.createStartMethodMatcher()).intercept((Implementation)Advice.to(StartAdvice.class)).method(ThreadSubclassInterceptor.createRunMethodMatcher()).intercept((Implementation)Advice.to(RunAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createThreadSubclassTypeMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.lang.Thread")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"java.lang.Thread").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"java.lang.ref"))));
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunMethodMatcher() {
        return ElementMatchers.named((String)"run").and((ElementMatcher)ElementMatchers.takesArguments((int)0));
    }

    static ElementMatcher.Junction<? super MethodDescription> createStartMethodMatcher() {
        return ElementMatchers.named((String)"start").and((ElementMatcher)ElementMatchers.takesArguments((int)0));
    }

    public static class RunAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.FieldValue(value="discoDecoration") DecoratedThread discoDecoration) {
            RunAdvice.methodEnter(discoDecoration);
        }

        public static void methodEnter(DecoratedThread discoDecoration) {
            try {
                if (discoDecoration != null) {
                    discoDecoration.before();
                }
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in Thread subclass", (Throwable)e);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit(@Advice.FieldValue(value="discoDecoration") DecoratedThread discoDecoration) {
            RunAdvice.methodExit(discoDecoration);
        }

        public static void methodExit(DecoratedThread discoDecoration) {
            try {
                if (discoDecoration != null) {
                    discoDecoration.after();
                }
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in Thread subclass", (Throwable)e);
            }
        }
    }

    public static class StartAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.FieldValue(readOnly=false, value="discoDecoration") DecoratedThread discoDecoration) {
            discoDecoration = StartAdvice.methodEnter();
        }

        public static DecoratedThread methodEnter() {
            try {
                DecoratedThread decoratedThread = new DecoratedThread();
                decoratedThread.removeTransactionContext(true);
                return decoratedThread;
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in Thread subclass", (Throwable)e);
                return null;
            }
        }
    }
}

