/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent.decorate;

import java.util.function.BiFunction;
import software.amazon.disco.agent.concurrent.decorate.Decorated;

public class DecoratedRunnable
extends Decorated
implements Runnable {
    Runnable target;

    DecoratedRunnable(Runnable target) {
        this.target = target;
    }

    public static DecoratedRunnable maybeCreate(Runnable target) {
        if (target == null) {
            return null;
        }
        if (target instanceof DecoratedRunnable) {
            return (DecoratedRunnable)target;
        }
        return new DecoratedRunnable(target);
    }

    public static DecoratedRunnable maybeCreate(Runnable target, boolean removeTX) {
        DecoratedRunnable decoratedRunnable = DecoratedRunnable.maybeCreate(target);
        if (decoratedRunnable != null && removeTX) {
            decoratedRunnable.removeTransactionContext(true);
        }
        return decoratedRunnable;
    }

    public Runnable getTarget() {
        return this.target;
    }

    @Override
    public void run() {
        this.before();
        try {
            this.target.run();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.after();
        }
    }

    public static class RunnableDecorateFunction
    implements BiFunction<Runnable, Boolean, Runnable> {
        @Override
        public Runnable apply(Runnable target, Boolean removeTX) {
            return DecoratedRunnable.maybeCreate(target, removeTX);
        }
    }
}

