/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import java.lang.instrument.Instrumentation;
import java.util.Set;
import java.util.function.Supplier;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.InterceptionListener;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class InterceptionInstaller {
    private static final InterceptionInstaller INSTANCE = new InterceptionInstaller(new DefaultAgentBuilderFactory());
    private static final Logger log = LogManager.getLogger(InterceptionInstaller.class);
    private final Supplier<AgentBuilder> agentBuilderFactory;

    InterceptionInstaller(Supplier<AgentBuilder> agentBuilderFactory) {
        this.agentBuilderFactory = agentBuilderFactory;
    }

    public static InterceptionInstaller getInstance() {
        return INSTANCE;
    }

    public void install(Instrumentation instrumentation, Set<Installable> installables, AgentConfig config, ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        ElementMatcher.Junction<? super TypeDescription> ignoreMatcher = InterceptionInstaller.createIgnoreMatcher(customIgnoreMatcher);
        for (Installable installable : installables) {
            AgentBuilder.Ignored agentBuilder = this.agentBuilderFactory.get().ignore(ignoreMatcher);
            if (config.isExtraverbose()) {
                agentBuilder = agentBuilder.with((AgentBuilder.Listener)InterceptionListener.create(installable));
            }
            agentBuilder = config.getAgentBuilderTransformer().apply((AgentBuilder)agentBuilder, installable);
            log.info("DiSCo(Core) attempting to install " + installable.getClass().getName());
            if ((agentBuilder = installable.install((AgentBuilder)agentBuilder)) == null) continue;
            agentBuilder.installOn(instrumentation);
        }
    }

    public static ElementMatcher.Junction<? super TypeDescription> createIgnoreMatcher(ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        ElementMatcher.Junction excludedNamespaces = ElementMatchers.nameStartsWith((String)"sun.").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"com.sun.")).or((ElementMatcher)ElementMatchers.nameStartsWith((String)"jdk.")).or((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.jacoco.")).or((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.junit.")).or((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.aspectj.")).or((ElementMatcher)ElementMatchers.nameStartsWith((String)"software.amazon.disco.agent.").and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameStartsWith((String)"software.amazon.disco.agent.integtest."))));
        return excludedNamespaces.or(customIgnoreMatcher);
    }

    private static class DefaultAgentBuilderFactory
    implements Supplier<AgentBuilder> {
        private DefaultAgentBuilderFactory() {
        }

        @Override
        public AgentBuilder get() {
            return new AgentBuilder.Default();
        }
    }
}

