/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ThreadInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ThreadInterceptor.class);

    ThreadInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).ignore((ElementMatcher)ElementMatchers.noneOf((Type[])new Type[]{Thread.class})).type(ThreadInterceptor.createThreadTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit((AsmVisitorWrapper)Advice.to(StartAdvice.class).on(ThreadInterceptor.createStartMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createThreadTypeMatcher() {
        return ElementMatchers.is(Thread.class);
    }

    static ElementMatcher.Junction<? super MethodDescription> createStartMethodMatcher() {
        return ElementMatchers.named((String)"start");
    }

    public static class StartAdvice {
        @Advice.OnMethodEnter
        public static void onStartEnter(@Advice.FieldValue(value="target", readOnly=false) Runnable target) {
            target = StartAdvice.wrap(target);
        }

        public static Runnable wrap(Runnable target) {
            try {
                Runnable decorated = DecoratedRunnable.maybeCreate(target);
                return decorated;
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to redirect Thread subclass to a DecoratedRunnable");
                return target;
            }
        }
    }
}

