/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnableScheduledFuture;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ScheduledThreadPoolExecutorInterceptor
implements Installable {
    private static Logger log = LogManager.getLogger(ScheduledThreadPoolExecutorInterceptor.class);

    ScheduledThreadPoolExecutorInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).type(ScheduledThreadPoolExecutorInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit((AsmVisitorWrapper)Advice.to(DecorateTaskAdvice.class).on(ScheduledThreadPoolExecutorInterceptor.createMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.isSubTypeOf(ScheduledThreadPoolExecutor.class);
    }

    static ElementMatcher.Junction<? super MethodDescription> createMethodMatcher() {
        return ElementMatchers.named((String)"decorateTask");
    }

    public static class DecorateTaskAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=1, readOnly=false) RunnableScheduledFuture task) {
            try {
                task = DecorateTaskAdvice.decorate(task);
            }
            catch (Throwable t) {
                DecorateTaskAdvice.captureThrowableForDebugging(t);
            }
        }

        public static RunnableScheduledFuture decorate(RunnableScheduledFuture task) {
            return DecoratedRunnableScheduledFuture.maybeCreate(task);
        }

        public static void captureThrowableForDebugging(Throwable t) {
            log.error("DiSCo(Concurrency) failed to decorate RunnableScheduledFuture for ScheduledThreadPoolExecutor", t);
        }
    }
}

