/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinTaskInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ForkJoinTaskInterceptor.class);

    ForkJoinTaskInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ForkJoinTaskInterceptor.createForkJoinTaskTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.implement(new Type[]{DecoratedForkJoinTask.Accessor.class}).defineField("$discoDecoration", DecoratedForkJoinTask.class, 4).defineMethod("getDiscoDecoration", DecoratedForkJoinTask.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).defineMethod("setDiscoDecoration", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(DecoratedForkJoinTask.class).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).method(ForkJoinTaskInterceptor.createForkMethodMatcher()).intercept((Implementation)Advice.to(ForkAdvice.class))).type(ForkJoinTaskInterceptor.createForkJoinTaskSubclassTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(ForkJoinTaskInterceptor.createExecMethodMatcher()).intercept((Implementation)Advice.to(ExecAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createForkJoinTaskTypeMatcher() {
        return ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask");
    }

    static ElementMatcher.Junction<? super TypeDescription> createForkJoinTaskSubclassTypeMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask"));
    }

    static ElementMatcher.Junction<? super MethodDescription> createForkMethodMatcher() {
        return ElementMatchers.named((String)"fork").and((ElementMatcher)ElementMatchers.takesArguments((int)0));
    }

    static ElementMatcher.Junction<? super MethodDescription> createExecMethodMatcher() {
        return ElementMatchers.named((String)"exec").and((ElementMatcher)ElementMatchers.isOverriddenFrom((ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }

    public static class ExecAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            ExecAdvice.methodEnter(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.getDiscoDecoration().before();
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ForkJoinTask");
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit(@Advice.This Object thiz) {
            ExecAdvice.methodExit(thiz);
        }

        public static void methodExit(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.getDiscoDecoration().after();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ForkAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            ForkAdvice.methodEnter(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedForkJoinTask.create());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

