/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.disco.agent.reflect.UncaughtExceptionHandler;
import software.amazon.disco.agent.reflect.logging.Logger;

public class ReflectiveCall<T> {
    private static final String DISCO_AGENT_PACKAGE_ROOT = "software.amazon.disco.agent";
    private static final String AGENT_TEMPLATE_CLASS_NAME = "software.amazon.disco.agent.DiscoAgentTemplate";
    private static final Map<String, Class> CACHED_TYPES = new ConcurrentHashMap<String, Class>();
    private static Boolean discoTemplateClassFound;
    private String fullClassName;
    private String methodName;
    private Object thiz;
    private Class returnType;
    private Class<?>[] argTypes;
    private T defaultValue;
    private Method method;
    static UncaughtExceptionHandler uncaughtExceptionHandler;

    private ReflectiveCall(Class returnType) {
        this.returnType = returnType;
    }

    public static ReflectiveCall returningVoid() {
        return new ReflectiveCall(Void.TYPE);
    }

    public static <T> ReflectiveCall<T> returning(Class<T> clazz) {
        return new ReflectiveCall<T>(clazz);
    }

    public ReflectiveCall<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ReflectiveCall<T> ofClass(String className) {
        this.fullClassName = DISCO_AGENT_PACKAGE_ROOT + className;
        return this;
    }

    public ReflectiveCall<T> ofMethod(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public ReflectiveCall<T> onInstance(Object thiz) {
        this.thiz = thiz;
        return this;
    }

    public ReflectiveCall<T> withArgTypes(Class ... argTypes) {
        this.argTypes = argTypes;
        return this;
    }

    public boolean methodFound() {
        if (this.method == null) {
            this.createMethod();
        }
        return this.method != null;
    }

    public T call(Object ... args) {
        try {
            if (this.method == null) {
                this.createMethod();
            }
            if (this.method == null) {
                return this.defaultValue;
            }
            return (T)this.method.invoke(this.thiz, args);
        }
        catch (IllegalAccessException e) {
            Logger.warn("IllegalAccessException when trying to call " + this.fullClassName + ":" + this.methodName);
        }
        catch (InvocationTargetException e) {
            this.dispatchException(e.getCause(), args);
        }
        return null;
    }

    public static boolean isAgentPresent() {
        if (discoTemplateClassFound == null) {
            discoTemplateClassFound = ReflectiveCall.retrieveCachedType(AGENT_TEMPLATE_CLASS_NAME) != null;
        }
        return discoTemplateClassFound;
    }

    public static void installUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        uncaughtExceptionHandler = handler;
    }

    public void dispatchException(Throwable t, Object ... args) {
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.handleUncaughtException(this, args, t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.returnType.getName() + " " + this.fullClassName + "::" + this.methodName + "(");
        List argTypeNames = Arrays.stream(this.argTypes).map(x -> x.getName()).collect(Collectors.toList());
        builder.append(String.join((CharSequence)", ", argTypeNames));
        builder.append(")");
        return builder.toString();
    }

    public String getClassName() {
        return this.fullClassName;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public static void resetCache() {
        CACHED_TYPES.clear();
        discoTemplateClassFound = null;
    }

    static Map<String, Class> getCachedTypes() {
        return CACHED_TYPES;
    }

    static void setDiscoTemplateClassFound(boolean classFound) {
        discoTemplateClassFound = classFound;
    }

    static Boolean getDiscoTemplateClassFound() {
        return discoTemplateClassFound;
    }

    private void createMethod() {
        try {
            Class clazz;
            if (ReflectiveCall.isAgentPresent() && (clazz = ReflectiveCall.retrieveCachedType(this.fullClassName)) != null) {
                this.method = clazz.getDeclaredMethod(this.methodName, this.argTypes);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Class retrieveCachedType(String fullClassName) {
        if (CACHED_TYPES.get(fullClassName) == null) {
            try {
                CACHED_TYPES.put(fullClassName, Class.forName(fullClassName));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return CACHED_TYPES.get(fullClassName);
    }

    static {
        uncaughtExceptionHandler = null;
    }
}

