/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import software.amazon.disco.agent.event.AbstractProtocolEvent;
import software.amazon.disco.agent.event.ProtocolRequestEvent;

public abstract class AbstractProtocolRequestEvent
extends AbstractProtocolEvent
implements ProtocolRequestEvent {
    public AbstractProtocolRequestEvent(String origin, String srcAddr, String dstAddr) {
        super(origin);
        this.withData(DataKey.SRC_ADDRESS.name(), srcAddr);
        this.withData(DataKey.DST_ADDRESS.name(), dstAddr);
    }

    public AbstractProtocolRequestEvent withRequest(Object request) {
        this.withData(DataKey.REQUEST.name(), request);
        return this;
    }

    @Override
    public Object getRequest() {
        return this.getData(DataKey.REQUEST.name());
    }

    @Override
    public String getSourceAddress() {
        return (String)this.getData(DataKey.SRC_ADDRESS.name());
    }

    @Override
    public String getDestinationAddress() {
        return (String)this.getData(DataKey.DST_ADDRESS.name());
    }

    static enum DataKey {
        REQUEST,
        SRC_ADDRESS,
        DST_ADDRESS;

    }
}

