/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax.client;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public final class HostPort {
    private final String mHost;
    private final int mPort;
    private final String mScheme;
    private static final Map<String, Integer> SCHEMES_TO_DEFAULT_PORTS = new HashMap<String, Integer>();

    public HostPort(String host, int port, String scheme) {
        this.mHost = host;
        this.mPort = port;
        this.mScheme = scheme;
    }

    public String host() {
        return this.mHost;
    }

    public int port() {
        return this.mPort;
    }

    public String scheme() {
        return this.mScheme;
    }

    public String toString() {
        return this.mScheme + "://" + this.mHost + ':' + this.mPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.mHost == null ? 0 : this.mHost.hashCode());
        return 31 * result + this.mPort + this.mScheme.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof HostPort)) {
            return false;
        }
        HostPort other = (HostPort)obj;
        return this.mHost.equals(other.mHost) && this.mPort == other.mPort && this.mScheme.equals(other.mScheme);
    }

    public static HostPort parse(String hostport) throws IllegalArgumentException {
        URI hostnameURI = null;
        String uri = hostport;
        int colon = hostport.indexOf("://");
        if (colon == -1) {
            if (hostport.indexOf(58) == -1) {
                throw new IllegalArgumentException("Invalid hostport: " + hostport);
            }
            uri = "dax://" + hostport;
        }
        try {
            hostnameURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid hostport: " + hostport, e);
        }
        String scheme = hostnameURI.getScheme();
        if (!SCHEMES_TO_DEFAULT_PORTS.containsKey(scheme)) {
            throw new IllegalArgumentException("URL scheme must be one of " + SCHEMES_TO_DEFAULT_PORTS.keySet());
        }
        String host = hostnameURI.getHost();
        int port = hostnameURI.getPort();
        if (host == null) {
            throw new IllegalArgumentException("Invalid hostport: " + hostport);
        }
        if (port == -1) {
            port = SCHEMES_TO_DEFAULT_PORTS.get(scheme);
        }
        return new HostPort(host, port, scheme);
    }

    public static String url(boolean ssl, String host, int port) {
        return (ssl ? "daxs://" : "dax://") + host + ":" + port;
    }

    public static String url(boolean ssl, InetAddress addr, int port) {
        String host = addr instanceof Inet6Address ? "[" + addr.getHostAddress() + "]" : addr.getHostAddress();
        return (ssl ? "daxs://" : "dax://") + host + ":" + port;
    }

    static {
        SCHEMES_TO_DEFAULT_PORTS.put("dax", 8111);
        SCHEMES_TO_DEFAULT_PORTS.put("daxs", 9111);
    }
}

