/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.Decoder;
import software.amazon.dax.com.amazon.cbor.IntRef;
import software.amazon.dax.com.amazon.cbor.NonInputStream;
import software.amazon.dax.com.amazon.dax.bits.DaxDecoder;
import software.amazon.dax.com.amazon.dax.bits.LexDecimal;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.ItemBuilder;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.DecoderException;
import software.amazon.dax.exceptions.MalformedResultException;

public final class AttributeValueDecoder {
    private AttributeValueDecoder() {
    }

    public static void decodeAnonymousItems(CborInputStream input, List<AttributeDefinition> keys, Map<Integer, DocumentPath> projOrdinals, List<Map<String, AttributeValue>> resultSet, List<List<AttributeValue>> anonAttributeValues, List<Long> attributeListIds) throws IOException {
        int type = input.fieldType();
        if (type == 246) {
            input.consumeField();
            return;
        }
        if (projOrdinals != null && !projOrdinals.isEmpty()) {
            if (type == 159) {
                input.consumeField();
                while (input.fieldType() != 255) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
                input.consumeField();
            } else {
                int len = input.readArrayLength();
                for (int i = 0; i < len; ++i) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
            }
            return;
        }
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        if (type == 159) {
            input.consumeField();
            while (input.fieldType() != 255) {
                ArrayList<AttributeValue> anonItem = new ArrayList<AttributeValue>();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
            input.consumeField();
        } else {
            int len = input.readArrayLength();
            for (int i = 0; i < len; ++i) {
                ArrayList<AttributeValue> anonItem = new ArrayList<AttributeValue>();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
        }
    }

    public static Map<String, AttributeValue> decodeScanItem(CborInputStream input, CborInputStream wrapper, List<AttributeDefinition> keys, List<Long> attributeListIds, List<AttributeValue> anonymousValues) throws IOException {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        int len = input.readArrayLength();
        if (len != 2) {
            throw new DecoderException("Item pair length is wrong: " + len);
        }
        AttributeValueDecoder.decodeKey(input, keys, item);
        input.beginStream();
        wrapper.init(input);
        attributeListIds.add(wrapper.readLong());
        AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper, anonymousValues);
        input.endStream();
        return item;
    }

    public static CompletableFuture<Map<String, AttributeValue>> decodeValue(CborInputStream input, Map<Integer, DocumentPath> projOrdinals, SimpleCache<Long, List<String>> attrListIdCache) throws IOException {
        int type = input.fieldType() & 0xE0;
        switch (type) {
            case 160: {
                return CompletableFuture.completedFuture(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
            }
            case 64: {
                CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
                input.beginStream();
                wrapper.init(input);
                CompletableFuture<Map<String, AttributeValue>> itemFuture = AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null);
                input.endStream();
                return itemFuture;
            }
            case 224: {
                if (input.fieldType() != 246) break;
                input.consumeField();
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new DecoderException("Value must be map or array, given cbor type: " + type);
    }

    public static Map<String, AttributeValue> deanonymizeAttributeValues(Map<String, AttributeValue> item, List<String> attributeNames, List<AttributeValue> attributeValues) throws IOException {
        if (item == null) {
            item = new ConcurrentHashMap<String, AttributeValue>();
        }
        if (attributeNames.size() != attributeValues.size()) {
            throw new MalformedResultException("Invalid AttributeList for item, must have same number of keys as values");
        }
        for (int i = 0; i < attributeNames.size(); ++i) {
            item.put(attributeNames.get(i), attributeValues.get(i));
        }
        return item;
    }

    public static CompletableFuture<Map<String, AttributeValue>> decodeStreamItem(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<String, AttributeValue> item) throws IOException {
        int fieldType = input.fieldType();
        if (fieldType == 246) {
            input.consumeField();
            return CompletableFuture.completedFuture(item);
        }
        Long attrListId = input.readLong();
        List<AttributeValue> attrValues = AttributeValueDecoder.decodeAnonymousStreamedItem(input, null);
        CompletableFuture<Map<String, AttributeValue>> itemFuture = new CompletableFuture<Map<String, AttributeValue>>();
        attrListIdCache.get(attrListId).whenComplete((attrNames, e) -> {
            if (e != null) {
                itemFuture.completeExceptionally((Throwable)e);
            } else {
                try {
                    itemFuture.complete(AttributeValueDecoder.deanonymizeAttributeValues(item, attrNames, attrValues));
                }
                catch (IOException ioException) {
                    itemFuture.completeExceptionally(ioException);
                }
            }
        });
        return itemFuture;
    }

    public static List<AttributeValue> decodeAnonymousStreamedItem(CborInputStream input, List<AttributeValue> anonymousValues) throws IOException {
        if (anonymousValues == null) {
            anonymousValues = new ArrayList<AttributeValue>();
        }
        while (input.fieldType() != -1) {
            AttributeValue.Builder av = AttributeValue.builder();
            AttributeValueDecoder.unpackAttributeValue(input, av);
            anonymousValues.add((AttributeValue)av.build());
        }
        return anonymousValues;
    }

    public static Map<String, AttributeValue> decodeProjection(CborInputStream input, Map<Integer, DocumentPath> projOrdinals, Map<String, AttributeValue> item) throws IOException {
        if (projOrdinals == null) {
            throw new DecoderException("Projection Ordinals must not be null on projected value");
        }
        ItemBuilder builder = ItemBuilder.create();
        if (input.fieldType() == 191) {
            input.consumeField();
            while (input.fieldType() != 255) {
                AttributeValueDecoder.decodeProjectionElement(input, projOrdinals, builder);
            }
            input.consumeField();
        } else {
            int len = input.readMapLength();
            for (int i = 0; i < len; ++i) {
                AttributeValueDecoder.decodeProjectionElement(input, projOrdinals, builder);
            }
        }
        return builder.toItem(item);
    }

    private static ItemBuilder decodeProjectionElement(CborInputStream input, Map<Integer, DocumentPath> projOrdinals, ItemBuilder builder) throws IOException {
        int ord = input.readInt();
        DocumentPath path = projOrdinals.get(ord);
        if (path == null) {
            throw new DecoderException("Unknown projection ordinal: " + ord);
        }
        AttributeValue.Builder av = AttributeValue.builder();
        AttributeValueDecoder.unpackAttributeValue(input, av);
        return builder.with(path, (AttributeValue)av.build());
    }

    public static void decodeCompoundKey(CborInputStream input, Map<String, AttributeValue> attrs) throws IOException {
        if (input.fieldType() == 246) {
            input.consumeField();
            return;
        }
        input.beginStream();
        CborInputStream wrapper = new CborInputStream(input, 1024);
        if (wrapper.fieldType() != 191) {
            throw new DecoderException("Unknown compound key");
        }
        wrapper.consumeField();
        while (wrapper.fieldType() != 255) {
            byte[] name = wrapper.readStringAsBytes();
            AttributeValue.Builder av = AttributeValue.builder();
            AttributeValueDecoder.unpackAttributeValue(wrapper, av);
            attrs.put(Decoder.decodeUtf8(name), (AttributeValue)av.build());
        }
        wrapper.consumeField();
        input.endStream();
    }

    public static void decodeNamedItem(CborInputStream input, List<AttributeDefinition> keys, Map<String, AttributeValue> item) throws IOException {
        AttributeDefinition hashKeyAttributeDefinition = keys.get(0);
        AttributeValue.Builder value = AttributeValue.builder();
        AttributeValueDecoder.unpackAttributeValue(input, value);
        item.put(hashKeyAttributeDefinition.attributeName(), (AttributeValue)value.build());
    }

    public static void decodeKey(CborInputStream input, List<AttributeDefinition> keys, Map<String, AttributeValue> item) throws IOException {
        byte[] key = (byte[])input.readObject();
        if (key == null) {
            return;
        }
        IntRef ref = new IntRef();
        AttributeDefinition ad = keys.get(0);
        if (keys.size() == 1) {
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().s(Decoder.decodeUtf8(key, 0, key.length)).build());
                    break;
                }
                case "N": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().n(DaxDecoder.decodeAnyCborNumber(key, ref).toString()).build());
                    break;
                }
                case "B": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(key))).build());
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
        } else {
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().s(new String(Decoder.decodeCborStringAsBytes(key, ref), StandardCharsets.UTF_8)).build());
                    break;
                }
                case "N": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().n(DaxDecoder.decodeAnyCborNumber(key, ref).toString()).build());
                    break;
                }
                case "B": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(Decoder.decodeCborBytes(key, ref)))).build());
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
            ad = keys.get(1);
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().s(Decoder.decodeUtf8(key, ref.value, key.length - ref.value)).build());
                    break;
                }
                case "N": {
                    BigDecimal[] bdRef = new BigDecimal[1];
                    LexDecimal.decode(key, ref.value, bdRef);
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().n(bdRef[0].toString()).build());
                    break;
                }
                case "B": {
                    item.put(ad.attributeName(), (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(key, ref.value, key.length - ref.value))).build());
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
        }
    }

    public static CompletableFuture<Map<String, AttributeValue>> decodeItemAttributeProjection(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<String, AttributeValue> it) throws IOException {
        HashMap item = it == null ? new HashMap() : it;
        int fieldType = input.fieldType();
        if (fieldType == 246) {
            input.consumeField();
            return CompletableFuture.completedFuture(item);
        }
        input.readBytesLength();
        Long attrListId = input.readLong();
        input.fieldType();
        input.consumeField();
        HashMap<Integer, AttributeValue> ordAvMap = new HashMap<Integer, AttributeValue>();
        while (input.fieldType() != 255) {
            int ordinal = input.readInt();
            AttributeValue.Builder av = AttributeValue.builder();
            AttributeValueDecoder.unpackAttributeValue(input, av);
            ordAvMap.put(ordinal, (AttributeValue)av.build());
        }
        input.consumeField();
        CompletableFuture<Map<String, AttributeValue>> itemFuture = new CompletableFuture<Map<String, AttributeValue>>();
        attrListIdCache.get(attrListId).whenComplete((attrNames, e) -> {
            if (e != null) {
                itemFuture.completeExceptionally((Throwable)e);
            } else {
                ordAvMap.forEach((k, v) -> item.put((String)attrNames.get((int)k), v));
                itemFuture.complete(item);
            }
        });
        return itemFuture;
    }

    private static void unpackAttributeValue(CborInputStream input, AttributeValue.Builder value) throws IOException {
        int fieldType = input.fieldType() & 0xFF;
        block18: while (true) {
            switch (fieldType >> 5) {
                case 2: {
                    value.b(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap((byte[])input.readObject())));
                    return;
                }
                case 3: {
                    value.s((String)input.readObject());
                    return;
                }
                case 4: {
                    int size = input.readArrayLength();
                    ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                    for (int i = 0; i < size; ++i) {
                        AttributeValue.Builder av = AttributeValue.builder();
                        AttributeValueDecoder.unpackAttributeValue(input, av);
                        avList.add((AttributeValue)av.build());
                    }
                    value.l(avList);
                    return;
                }
                case 5: {
                    int size = input.readMapLength();
                    LinkedHashMap<String, AttributeValue> avMap = new LinkedHashMap<String, AttributeValue>(size);
                    for (int i = 0; i < size; ++i) {
                        Object name = input.readObject();
                        AttributeValue.Builder av = AttributeValue.builder();
                        AttributeValueDecoder.unpackAttributeValue(input, av);
                        if (name == null) {
                            avMap.put(null, (AttributeValue)av.build());
                            continue;
                        }
                        avMap.put(name.toString(), (AttributeValue)av.build());
                    }
                    value.m(avMap);
                    return;
                }
                case 7: {
                    switch (fieldType & 0x1F) {
                        case 21: {
                            value.bool(Boolean.valueOf(true));
                            break;
                        }
                        case 20: {
                            value.bool(Boolean.valueOf(false));
                            break;
                        }
                        case 22: {
                            value.nul(Boolean.valueOf(true));
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    input.consumeField();
                    return;
                }
                case 0: 
                case 1: {
                    value.n(input.readObject().toString());
                    return;
                }
                case 6: {
                    long tag = input.getFieldValue();
                    if (tag < 3321L || tag > 3323L) break block18;
                    input.consumeField();
                    fieldType = input.fieldType() & 0xE0;
                    if (fieldType == 128) {
                        switch ((int)tag) {
                            default: {
                                AttributeValueDecoder.unpackStringSet(input, value);
                                return;
                            }
                            case 3322: {
                                AttributeValueDecoder.unpackNumberSet(input, value);
                                return;
                            }
                            case 3323: 
                        }
                        AttributeValueDecoder.unpackBinarySet(input, value);
                        return;
                    }
                }
                default: {
                    fieldType = input.fieldType();
                    continue block18;
                }
            }
            break;
        }
        AttributeValueDecoder.setObject(value, input.readObject());
    }

    private static void unpackStringSet(CborInputStream input, AttributeValue.Builder value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<String> set = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            int fieldType = input.fieldType() & 0xE0;
            if (fieldType != 96) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add((AttributeValue)AttributeValue.builder().s((String)set.get(i)).build());
                }
                while (i < size) {
                    AttributeValue.Builder av = AttributeValue.builder();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add((AttributeValue)av.build());
                    ++i;
                }
                value.l(avList);
                return;
            }
            set.add((String)input.readObject());
        }
        value.ss(set);
    }

    private static void unpackNumberSet(CborInputStream input, AttributeValue.Builder value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<String> set = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Object obj = input.readObject();
            if (!(obj instanceof Number)) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add((AttributeValue)AttributeValue.builder().n((String)set.get(i)).build());
                }
                AttributeValue.Builder av = AttributeValue.builder();
                AttributeValueDecoder.setObject(av, obj);
                avList.add((AttributeValue)av.build());
                ++i;
                while (i < size) {
                    av = AttributeValue.builder();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add((AttributeValue)av.build());
                    ++i;
                }
                value.l(avList);
                return;
            }
            set.add(obj.toString());
        }
        value.ns(set);
    }

    private static void unpackBinarySet(CborInputStream input, AttributeValue.Builder value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<SdkBytes> set = new ArrayList<SdkBytes>(size);
        for (int i = 0; i < size; ++i) {
            int fieldType = input.fieldType() & 0xE0;
            if (fieldType != 64) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add((AttributeValue)AttributeValue.builder().b((SdkBytes)set.get(i)).build());
                }
                while (i < size) {
                    AttributeValue.Builder av = AttributeValue.builder();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add((AttributeValue)av.build());
                    ++i;
                }
                value.l(avList);
                return;
            }
            set.add(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap((byte[])input.readObject())));
        }
        value.bs(set);
    }

    private static void setObject(AttributeValue.Builder value, Object obj) {
        if (obj == null) {
            value.nul(Boolean.valueOf(true));
        } else if (obj instanceof Number) {
            value.n(obj.toString());
        } else if (obj instanceof String) {
            value.s(obj.toString());
        } else if (obj instanceof byte[]) {
            value.b(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap((byte[])obj)));
        } else {
            throw new DecoderException("Unknown object type: " + obj + ", " + obj.getClass());
        }
    }
}

