/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.DynamoDBV1Converter;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.expr.ExpressionValidationModel;

public class GetItemRequestEncoder
extends RequestEncoder<GetItemRequest> {
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals;

    public GetItemRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.projectionOrdinals = projectionOrdinals;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, GetItemRequest request, ChannelPromise promise) {
        RequestValidator.validateTableName(request.tableName());
        RequestValidator.validateExpression(new ExpressionValidationModel().projectionExpression(request.projectionExpression()).attributesToGet(request.hasAttributesToGet() ? request.attributesToGet() : null).expressionAttributeNames(request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null));
        this.cache.get(request.tableName()).whenComplete((keys, e) -> {
            if (e != null) {
                promise.setFailure(e);
            } else {
                try {
                    this.encodeAndWrite(ctx, request, (List<AttributeDefinition>)keys, promise);
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, GetItemRequest request, List<AttributeDefinition> keys, ChannelPromise promise) throws IOException {
        ByteBuf buffer = ctx.alloc().buffer();
        SegmentPool.Segment cborKey = this.segmentPool.alloc();
        try (DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);){
            boolean hasKwargs;
            out.writeInt(1);
            out.writeInt(263244906);
            out.writeBytes(Encoder.encodeUtf8(request.tableName()));
            AttributeValueEncoder.validateAndEncodeKey(this.segmentPool, cborKey, request.key(), keys);
            out.writeBytes(this.segmentPool.chainCopyAndTrim(cborKey, 0));
            byte[] kwargs = null;
            boolean bl = hasKwargs = request.hasAttributesToGet() || request.consistentRead() != null || request.projectionExpression() != null || request.returnConsumedCapacity() != null;
            if (hasKwargs) {
                kwargs = this.encodeKwargs(request);
                out.write(kwargs);
            } else {
                out.writeNull();
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
        finally {
            this.segmentPool.chainRecycle(cborKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodeKwargs(GetItemRequest request) {
        SegmentPool.Segment kwargsHead = this.segmentPool.alloc();
        try {
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity;
            Object object;
            DynamoDBExpressionInfo exp = null;
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            String projectionExpression = exp.getProjectionExpression();
            Map<String, String> expressionAttributeNames = exp.getExpressionAttributeNames();
            SegmentPool.Segment kwargsTail = kwargsHead;
            kwargsTail = this.segmentPool.chainAppendCborMapStreamPrefix(kwargsTail);
            if (projectionExpression != null) {
                this.projectionOrdinals.compareAndSet(null, new HashMap());
                byte[] projection = AttributeValueEncoder.encodeProjection(projectionExpression, expressionAttributeNames);
                AttributeValueEncoder.prepareProjection(projectionExpression, expressionAttributeNames, this.projectionOrdinals.get());
                kwargsTail = this.segmentPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ProjectionExpression.ordinal());
                kwargsTail = this.segmentPool.chainAppendCborBytes(kwargsTail, projection);
                if (expressionAttributeNames != null) {
                    kwargsTail = this.segmentPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ExpressionAttributeNames.ordinal());
                    kwargsTail = this.segmentPool.chainAppendCborMapPrefix(kwargsTail, expressionAttributeNames.size());
                    object = expressionAttributeNames.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry name = (Map.Entry)object.next();
                        kwargsTail = this.segmentPool.chainAppendCborString(kwargsTail, (String)name.getKey());
                        kwargsTail = this.segmentPool.chainAppendCborString(kwargsTail, (String)name.getValue());
                    }
                }
            }
            if (request.consistentRead() != null && request.consistentRead().booleanValue()) {
                kwargsTail = this.segmentPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ConsistentRead.ordinal());
                kwargsTail = this.segmentPool.chainAppend(kwargsTail, (byte)-11);
            }
            if ((returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString())) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                kwargsTail = this.segmentPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ReturnConsumedCapacity.ordinal());
                kwargsTail = this.segmentPool.chainAppendCborInteger(kwargsTail, returnConsumedCapacity.mCode);
            }
            this.segmentPool.chainAppendCborStreamBreak(kwargsTail);
            object = this.segmentPool.chainCopyAndTrim(kwargsHead, 0);
            return object;
        }
        finally {
            this.segmentPool.chainRecycle(kwargsHead);
        }
    }
}

